/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.LOF;

import java.util.ArrayList;

public class LOF {
    private int k;

    public LOF(int k) {
        this.k = k;
    }

    public double getLOF(double[][] knn, double[] x) {
        double sum = 0.0;
        for (double[] o : knn) {
            sum += this.getLocDens(knn, o) / this.getLocDens(knn, x);
        }
        return sum / (double)this.k;
    }

    public double getLocDens(double[][] knn, double[] x) {
        double[] nnk = this.findKthPoint(knn, x);
        double sum = 0.0;
        for (double[] o : knn) {
            sum += this.reachDist(o, x, nnk);
        }
        return sum / (double)this.k;
    }

    public double[] findKthPoint(double[][] knn, double[] x) {
        ArrayList<double[]> list = new ArrayList<double[]>();
        for (int i = 0; i < knn.length; ++i) {
            list.add(knn[i]);
        }
        int index = 0;
        double minDist = this.dist(knn[0], x);
        for (int i = 0; i < this.k; ++i) {
            index = 0;
            minDist = this.dist((double[])list.get(0), x);
            for (int j = 0; j < list.size(); ++j) {
                if (!(minDist > this.dist((double[])list.get(j), x))) continue;
                minDist = this.dist((double[])list.get(j), x);
                index = j;
            }
            if (i == this.k - 1) continue;
            list.remove(index);
        }
        return (double[])list.get(index);
    }

    public double reachDist(double[] o, double[] x, double[] nnk) {
        return Math.max(this.dist(o, x), this.dist(nnk, x));
    }

    private double dist(double[] nnk, double[] x) {
        double sum = 0.0;
        for (int i = 0; i < nnk.length; ++i) {
            sum += (nnk[i] - x[i]) * (nnk[i] - x[i]);
        }
        return Math.sqrt(sum);
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }
}

