/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.LOF;

import com.anomalydetect.LOF.LOF;
import com.anomalydetect.Result.Result;
import com.anomalydetect.Tool.DetectTool;
import com.anomalydetect.Util.MatrixUtil;
import java.util.ArrayList;

public class LOFDetectTool
implements DetectTool {
    private int T;
    private int L;
    private int K = 1;
    private ArrayList<Result> results;

    public LOFDetectTool(int T, int L) {
        this.T = T;
        this.L = L;
    }

    @Override
    public void timeSeriesAnalyse(double[] series) {
        double[][] mat = MatrixUtil.getMat(series, this.T, series.length - this.T - this.L + 1, this.L);
        double[] test = MatrixUtil.getTestSeries(series, series.length - this.L, this.L);
        double[][] matC = MatrixUtil.getMatC(mat, this.T, series.length - this.T - this.L + 1, this.L);
        double[][] matT = MatrixUtil.getMatT(mat, this.T, series.length - this.T - this.L + 1, this.L);
        LOF lof = new LOF(this.K);
        double[] ncmForC = new double[matC.length];
        for (int i = 0; i < matC.length; ++i) {
            ncmForC[i] = lof.getLOF(matT, matC[i]);
        }
        double ncmForTest = lof.getLOF(matT, test);
        double count = 0.0;
        for (double x : ncmForC) {
            if (!(ncmForTest <= x)) continue;
            count += 1.0;
        }
        System.out.println("Anomaly Score is " + (count /= (double)matC.length));
    }

    public int getT() {
        return this.T;
    }

    public void setT(int t) {
        this.T = t;
    }

    public int getL() {
        return this.L;
    }

    public void setL(int l) {
        this.L = l;
    }

    public int getK() {
        return this.K;
    }

    public void setK(int k) {
        this.K = k;
    }

    public ArrayList<Result> getResults() {
        return this.results;
    }

    public void setResults(ArrayList<Result> results) {
        this.results = results;
    }
}

