/*
 * Decompiled with CFR 0.152.
 */
package com.anomalydetect.Tool;

public class MathTool {
    public static double EulerConstant = 0.5772156649015329;

    private MathTool() {
    }

    public static double dist(double[] data, int p, int q, int length) {
        double dist = 0.0;
        for (int i = 0; i < length; ++i) {
            dist += Math.pow(data[p + i] - data[q + i], 2.0);
        }
        return Math.sqrt(dist);
    }

    public static double distForMulti(double[][] data, int p, int q, int length, int n) {
        double dist = 0.0;
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < n; ++j) {
                dist += Math.pow(data[p + i][j] - data[q + i][j], 2.0);
            }
        }
        return Math.sqrt(dist);
    }

    public static double[] gassian(double[] data) {
        double[] temp = (double[])data.clone();
        double avg = MathTool.getAverageFromArray(data);
        double s = MathTool.getStdDeviation(data);
        for (int i = 0; i < data.length; ++i) {
            temp[i] = (temp[i] - avg) / s;
        }
        return temp;
    }

    public static double[] normalize(double[] data) {
        double[] temp = (double[])data.clone();
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        for (double n : data) {
            if (max < n) {
                max = n;
            }
            if (!(min > n)) continue;
            min = n;
        }
        for (int i = 0; i < data.length; ++i) {
            temp[i] = (temp[i] - min) / max;
        }
        return temp;
    }

    public static double getAverageFromArray(double[] array) {
        double sum = 0.0;
        for (double d : array) {
            sum += d;
        }
        return sum / (double)array.length;
    }

    public static double getStdDeviation(double[] array) {
        double average = MathTool.getAverageFromArray(array);
        double sum = 0.0;
        for (double d : array) {
            sum += Math.pow(d - average, 2.0);
        }
        return Math.sqrt(sum / (double)(array.length - 1));
    }

    public static double log2(double value) {
        return Math.log(value) / Math.log(2.0);
    }
}

