/*
 * Decompiled with CFR 0.152.
 */
package com.github.mfathi91.time;

import com.github.mfathi91.time.MyUtils;
import net.jcip.annotations.Immutable;

@Immutable
public enum PersianMonth {
    FARVARDIN("\u0641\u0631\u0648\u0631\u062f\u06cc\u0646"),
    ORDIBEHESHT("\u0627\u0631\u062f\u06cc\u0628\u0647\u0634\u062a"),
    KHORDAD("\u062e\u0631\u062f\u0627\u062f"),
    TIR("\u062a\u06cc\u0631"),
    MORDAD("\u0645\u0631\u062f\u0627\u062f"),
    SHAHRIVAR("\u0634\u0647\u0631\u06cc\u0648\u0631"),
    MEHR("\u0645\u0647\u0631"),
    ABAN("\u0622\u0628\u0627\u0646"),
    AZAR("\u0622\u0630\u0631"),
    DEY("\u062f\u06cc"),
    BAHMAN("\u0628\u0647\u0645\u0646"),
    ESFAND("\u0627\u0633\u0641\u0646\u062f");

    private final String persianName;

    private PersianMonth(String persianName) {
        this.persianName = persianName;
    }

    public String getPersianName() {
        return this.persianName;
    }

    static PersianMonth of(int month) {
        MyUtils.intRequireRange(month, 1, 12, "month");
        return PersianMonth.values()[month - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public int length(boolean leapYear) {
        int value = this.getValue();
        return value < 7 ? 31 : (value != 12 ? 30 : (leapYear ? 30 : 29));
    }

    public int maxLength() {
        return this.length(true);
    }

    public int minLength() {
        return this.length(false);
    }

    public PersianMonth plus(long months) {
        int amount = (int)(months % 12L);
        amount = (amount + 12) % 12;
        return PersianMonth.values()[(this.ordinal() + amount) % 12];
    }

    public PersianMonth minus(long months) {
        return this.plus(-months);
    }

    public int daysToFirstOfMonth() {
        int val = this.getValue();
        return val <= 6 ? 31 * (val - 1) : 30 * (val - 1 - 6) + 186;
    }
}

