/*
 * Decompiled with CFR 0.152.
 */
package com.github.mfathi91.time;

import com.github.mfathi91.time.MyUtils;
import com.github.mfathi91.time.PersianChronology;
import com.github.mfathi91.time.PersianMonth;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Period;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.JulianFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class PersianDate
implements ChronoLocalDate {
    public static final PersianDate MIN = PersianDate.of((int)PersianChronology.INSTANCE.range(ChronoField.YEAR).getMinimum(), 1, 1);
    public static final PersianDate MAX = PersianDate.of((int)PersianChronology.INSTANCE.range(ChronoField.YEAR).getMaximum(), 12, 29);
    private static final long JULIAN_DAY_TO_1970 = 2440588L;
    private static final long CYCLE_DAYS = 1029983L;
    private static final int CYCLE_YEARS = 2820;
    private static final double YEAR_LENGTH = 365.2421985815603;
    private static final long PERSIAN_DATE_EPOCH = 2121446L;
    private static final double LEAP_THRESHOLD = 0.24219858156028368;
    private final int year;
    private final int month;
    private final int day;

    public int getYear() {
        return this.year;
    }

    public PersianMonth getMonth() {
        return PersianMonth.of(this.month);
    }

    public int getMonthValue() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfYear() {
        return PersianMonth.of(this.month).daysToFirstOfMonth() + this.day;
    }

    public DayOfWeek getDayOfWeek() {
        int dow0 = Math.floorMod((int)this.toEpochDay() + 3, 7);
        return DayOfWeek.of(dow0 + 1);
    }

    public static PersianDate now() {
        return PersianDate.ofJulianDays(JulianFields.JULIAN_DAY.getFrom(LocalDate.now()));
    }

    public static PersianDate of(int year, int month, int dayOfMonth) {
        return new PersianDate(year, month, dayOfMonth);
    }

    public static PersianDate of(int year, PersianMonth month, int dayOfMonth) {
        Objects.requireNonNull(month, "month");
        return new PersianDate(year, month.getValue(), dayOfMonth);
    }

    public static PersianDate fromGregorian(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return PersianDate.ofJulianDays(JulianFields.JULIAN_DAY.getFrom(localDate));
    }

    public static PersianDate parse(CharSequence text) {
        return PersianDate.parse(text, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static PersianDate parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.withChronology(PersianChronology.INSTANCE).parse(text, PersianDate::from);
    }

    public static PersianDate from(TemporalAccessor temporal) {
        Objects.requireNonNull(temporal, "temporal");
        return PersianChronology.INSTANCE.date(temporal);
    }

    public static PersianDate ofEpochDay(long epochDays) {
        return PersianDate.ofJulianDays(epochDays + 2440588L);
    }

    public static PersianDate ofJulianDays(long julianDays) {
        int month;
        long offset = julianDays - 2121446L;
        long cycle_no = offset / 1029983L;
        if (offset < 0L) {
            --cycle_no;
        }
        long cycleStart = 2121446L + cycle_no * 1029983L;
        int yc = (int)Math.floor((double)(julianDays - cycleStart) / 365.2421985815603);
        long year = (long)(yc + 475) + cycle_no * 2820L;
        long lll = 2121446L + cycle_no * 1029983L + (long)Math.floor((double)yc * 365.2421985815603);
        long day = julianDays - lll + 1L;
        if (day > (long)(PersianDate.isLeapYear((int)year) ? 366 : 365)) {
            ++year;
            day = 1L;
        }
        if (year <= 0L) {
            --year;
        }
        for (month = 1; month < 12 && day > (long)PersianMonth.of(month).length(PersianDate.isLeapYear((int)year)); day -= (long)PersianMonth.of(month).length(PersianDate.isLeapYear((int)year)), ++month) {
        }
        return PersianDate.of((int)year, month, (int)day);
    }

    private PersianDate(int year, int month, int dayOfMonth) {
        PersianChronology.INSTANCE.checkValidValue(year, ChronoField.YEAR);
        PersianChronology.INSTANCE.checkValidValue(month, ChronoField.MONTH_OF_YEAR);
        boolean leapYear = PersianChronology.INSTANCE.isLeapYear(year);
        int maxDaysOfMonth = PersianMonth.of(month).length(leapYear);
        if (dayOfMonth > maxDaysOfMonth) {
            if (month == 12 && dayOfMonth == 30 && !leapYear) {
                throw new DateTimeException("Invalid date ESFAND 30, as " + year + " is not a leap year");
            }
            throw new DateTimeException("Invalid date " + PersianMonth.of(month).name() + " " + dayOfMonth);
        }
        this.year = year;
        this.month = month;
        this.day = dayOfMonth;
    }

    @Override
    public Chronology getChronology() {
        return PersianChronology.INSTANCE;
    }

    @Override
    public int lengthOfMonth() {
        PersianMonth pm = PersianMonth.of(this.month);
        return PersianChronology.INSTANCE.isLeapYear(this.year) ? pm.maxLength() : pm.minLength();
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        Objects.requireNonNull(endExclusive, "endExclusive");
        Objects.requireNonNull(unit, "unit");
        PersianDate end = (PersianDate)this.getChronology().date(endExclusive);
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case DAYS: {
                    return this.daysUntil(end);
                }
                case WEEKS: {
                    return this.daysUntil(end) / 7L;
                }
                case MONTHS: {
                    return this.monthsUntil(end);
                }
                case YEARS: {
                    return this.monthsUntil(end) / 12L;
                }
                case DECADES: {
                    return this.monthsUntil(end) / 120L;
                }
                case CENTURIES: {
                    return this.monthsUntil(end) / 1200L;
                }
                case MILLENNIA: {
                    return this.monthsUntil(end) / 12000L;
                }
                case ERAS: {
                    return end.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
        }
        return unit.between(this, end);
    }

    private long daysUntil(PersianDate end) {
        return end.toEpochDay() - this.toEpochDay();
    }

    private long monthsUntil(PersianDate end) {
        long packed1 = this.getLong(ChronoField.PROLEPTIC_MONTH) * 32L + (long)this.getDayOfMonth();
        long packed2 = end.getLong(ChronoField.PROLEPTIC_MONTH) * 32L + (long)end.getDayOfMonth();
        return (packed2 - packed1) / 32L;
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDateExclusive) {
        Objects.requireNonNull(endDateExclusive, "endDateExclusive");
        PersianDate end = PersianChronology.INSTANCE.date(endDateExclusive);
        long totalMonths = end.getLong(ChronoField.PROLEPTIC_MONTH) - this.getLong(ChronoField.PROLEPTIC_MONTH);
        int days = end.day - this.day;
        if (totalMonths > 0L && days < 0) {
            PersianDate calcDate = this.plusMonths(--totalMonths);
            days = (int)(end.toEpochDay() - calcDate.toEpochDay());
        } else if (totalMonths < 0L && days > 0) {
            ++totalMonths;
            days -= end.lengthOfMonth();
        }
        long years = totalMonths / 12L;
        int months = (int)(totalMonths % 12L);
        return Period.of(Math.toIntExact(years), months, days);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case DAY_OF_WEEK: {
                    return this.getDayOfWeek().getValue();
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return (this.day - 1) % 7 + 1;
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return (this.getDayOfYear() - 1) % 7 + 1;
                }
                case DAY_OF_MONTH: {
                    return this.day;
                }
                case DAY_OF_YEAR: {
                    return this.getDayOfYear();
                }
                case EPOCH_DAY: {
                    return this.toEpochDay();
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return (this.day - 1) / 7 + 1;
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return (this.getDayOfYear() - 1) / 7 + 1;
                }
                case MONTH_OF_YEAR: {
                    return this.month;
                }
                case PROLEPTIC_MONTH: {
                    return (long)this.year * 12L + (long)this.month - 1L;
                }
                case YEAR_OF_ERA: {
                    return this.year >= 1 ? this.year : 1 - this.year;
                }
                case YEAR: {
                    return this.year;
                }
                case ERA: {
                    return this.year >= 1 ? 1 : 0;
                }
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
    }

    public PersianDate plusYears(long yearsToAdd) {
        return this.plusMonths(yearsToAdd * 12L);
    }

    public PersianDate plusMonths(long monthsToAdd) {
        if (monthsToAdd == 0L) {
            return this;
        }
        long monthCount = (long)this.year * 12L + (long)(this.month - 1);
        long calcMonths = monthCount + monthsToAdd;
        int newYear = (int)Math.floorDiv(calcMonths, 12L);
        int newMonth = (int)Math.floorMod(calcMonths, 12L) + 1;
        return this.resolvePreviousValid(newYear, newMonth, this.day);
    }

    public PersianDate plusDays(long daysToAdd) {
        if (daysToAdd == 0L) {
            return this;
        }
        return PersianDate.ofJulianDays(this.toJulianDay() + daysToAdd);
    }

    @Override
    public boolean isLeapYear() {
        return PersianDate.isLeapYear(this.year);
    }

    public static boolean isLeapYear(int year) {
        MyUtils.intRequirePositive(year, "year");
        return (double)(year + 2346) * 0.24219858156028368 % 1.0 < 0.24219858156028368;
    }

    private PersianDate resolvePreviousValid(int year, int month, int day) {
        boolean leapYear = PersianChronology.INSTANCE.isLeapYear(year);
        int maxDaysOfMonth = PersianMonth.of(month).length(leapYear);
        if (day > maxDaysOfMonth) {
            day = maxDaysOfMonth;
        }
        return PersianDate.of(year, month, day);
    }

    public LocalDate toGregorian() {
        return LocalDate.from(this);
    }

    @Override
    public long toEpochDay() {
        return this.toJulianDay() - 2440588L;
    }

    public long toJulianDay() {
        return PersianDate.toJulianDay(this.year, this.month, this.day);
    }

    static long toJulianDay(int year, int month, int dayOfMonth) {
        long era = (year - 475) / 2820;
        if (year - 475 < 0) {
            --era;
        }
        long y_c = (long)(year - 475) - era * 2820L;
        long f_d = 2121446L + era * 1029983L + (long)Math.floor((double)y_c * 365.2421985815603);
        return f_d + (long)PersianMonth.of(month).daysToFirstOfMonth() + (long)dayOfMonth - 1L;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PersianDate) {
            return this.compareTo((PersianDate)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day);
    }

    @Override
    public String toString() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }
}

