/*
 * Decompiled with CFR 0.152.
 */
package humanize;

import com.google.common.collect.ObjectArrays;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transliterator;
import humanize.icu.spi.MessageFormat;
import humanize.icu.spi.context.DefaultICUContext;
import humanize.icu.spi.context.ICUContextFactory;
import humanize.spi.context.ContextFactory;
import humanize.text.util.InterpolationHelper;
import humanize.text.util.Replacer;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;

public final class ICUHumanize {
    private static final ContextFactory contextFactory = ICUHumanize.loadContextFactory();
    private static final ThreadLocal<DefaultICUContext> context = new ThreadLocal<DefaultICUContext>(){

        @Override
        protected DefaultICUContext initialValue() {
            return (DefaultICUContext)contextFactory.createContext();
        }
    };

    public static String compactDecimal(Number value) {
        NumberFormat fmt = context.get().getCompactDecimalFormat();
        return fmt.format((Object)value);
    }

    public static String compactDecimal(Number value, CompactDecimalFormat.CompactStyle style) {
        NumberFormat fmt = context.get().getCompactDecimalFormat(style);
        return fmt.format((Object)value);
    }

    public static String compactDecimal(final Number value, final CompactDecimalFormat.CompactStyle style, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.compactDecimal(value, style);
            }
        }, locale);
    }

    public static String compactDecimal(Number value, Locale locale) {
        return ICUHumanize.compactDecimal(value, CompactDecimalFormat.CompactStyle.SHORT, locale);
    }

    public static DateFormat dateFormatInstance(String pattern) {
        return DateFormat.getPatternInstance((String)pattern, (Locale)context.get().getLocale());
    }

    public static DateFormat dateFormatInstance(final String pattern, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<DateFormat>(){

            @Override
            public DateFormat call() throws Exception {
                return ICUHumanize.dateFormatInstance(pattern);
            }
        }, locale);
    }

    public static DecimalFormat decimalFormatInstance(String pattern) {
        DecimalFormat decFmt = context.get().getDecimalFormat();
        decFmt.applyPattern(pattern);
        return decFmt;
    }

    public static DecimalFormat decimalFormatInstance(final String pattern, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return ICUHumanize.decimalFormatInstance(pattern);
            }
        }, locale);
    }

    public static String duration(final Number value) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((DefaultICUContext)context.get()).getRuleBasedNumberFormat(3).format((Object)value);
            }
        }, Locale.ENGLISH);
    }

    public static String format(String pattern, Object ... args) {
        return ICUHumanize.messageFormatInstance(pattern).render(args);
    }

    public static String formatCurrency(Number value) {
        DecimalFormat decf = context.get().getCurrencyFormat();
        return ICUHumanize.stripZeros(decf, decf.format((Object)value));
    }

    public static String formatCurrency(final Number value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return ICUHumanize.formatCurrency(value);
            }
        }, locale);
    }

    public static String formatDate(Date value) {
        return ICUHumanize.formatDate(3, value);
    }

    public static String formatDate(final Date value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.formatDate(value);
            }
        }, locale);
    }

    public static String formatDate(Date value, String pattern) {
        return new SimpleDateFormat(pattern, context.get().getLocale()).format(value);
    }

    public static String formatDate(final Date value, final String pattern, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.formatDate(value, pattern);
            }
        }, locale);
    }

    public static String formatDate(int style, Date value) {
        return context.get().formatDate(style, value);
    }

    public static String formatDate(final int style, final Date value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.formatDate(style, value);
            }
        }, locale);
    }

    public static String formatDateTime(Date value) {
        return context.get().formatDateTime(value);
    }

    public static String formatDateTime(final Date value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.formatDateTime(value);
            }
        }, locale);
    }

    public static String formatDateTime(int dateStyle, int timeStyle, Date value) {
        return context.get().formatDateTime(dateStyle, timeStyle, value);
    }

    public static String formatDateTime(final int dateStyle, final int timeStyle, final Date value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.formatDateTime(dateStyle, timeStyle, value);
            }
        }, locale);
    }

    public static String formatDecimal(Number value) {
        return context.get().formatDecimal(value);
    }

    public static String formatDecimal(final Number value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return ICUHumanize.formatDecimal(value);
            }
        }, locale);
    }

    public static String formatPercent(Number value) {
        return context.get().getPercentFormat().format((Object)value);
    }

    public static String formatPercent(final Number value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.formatPercent(value);
            }
        }, locale);
    }

    public static String formatPluralCurrency(Number value) {
        DecimalFormat decf = context.get().getPluralCurrencyFormat();
        return ICUHumanize.stripZeros(decf, decf.format((Object)value));
    }

    public static String formatPluralCurrency(final Number value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.formatPluralCurrency(value);
            }
        }, locale);
    }

    public static MessageFormat messageFormatInstance(String pattern) {
        MessageFormat msg = context.get().getMessageFormat();
        msg.applyPattern(pattern);
        return msg;
    }

    public static MessageFormat messageFormatInstance(final String pattern, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<MessageFormat>(){

            @Override
            public MessageFormat call() throws Exception {
                return ICUHumanize.messageFormatInstance(pattern);
            }
        }, locale);
    }

    public static String naturalDay(Date value) {
        return ICUHumanize.naturalDay(131, value);
    }

    public static String naturalDay(final Date value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.naturalDay(value);
            }
        }, locale);
    }

    public static String naturalDay(int style, Date value) {
        return ICUHumanize.formatDate(style, value).toLowerCase();
    }

    public static String naturalTime(Date duration) {
        return context.get().getDurationFormat().formatDurationFromNowTo(duration);
    }

    public static String naturalTime(Date reference, Date duration) {
        long diff = duration.getTime() - reference.getTime();
        return context.get().getDurationFormat().formatDurationFrom(diff, reference.getTime());
    }

    public static String naturalTime(final Date reference, final Date duration, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return ICUHumanize.naturalTime(reference, duration);
            }
        }, locale);
    }

    public static String naturalTime(Date duration, Locale locale) {
        return ICUHumanize.naturalTime(new Date(), duration, locale);
    }

    public static String ordinalize(Number value) {
        return context.get().getRuleBasedNumberFormat(2).format((Object)value);
    }

    public static String ordinalize(final Number value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return ICUHumanize.ordinalize(value);
            }
        }, locale);
    }

    public static Number parseNumber(String text) throws ParseException {
        return context.get().getRuleBasedNumberFormat(1).parse(text);
    }

    public static Number parseNumber(final String text, Locale locale) throws ParseException {
        return ICUHumanize.withinLocale(new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return ICUHumanize.parseNumber(text);
            }
        }, locale);
    }

    public static String pluralize(Locale locale, final String pattern, final Number value, final Object ... args) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.pluralize(pattern, value, args);
            }
        }, locale);
    }

    public static String pluralize(String pattern, Number value, Object ... args) {
        Object[] params = ObjectArrays.concat((Object)value, (Object[])args);
        return ICUHumanize.messageFormatInstance(pattern).render(params);
    }

    public static String replaceSupplementary(String value) {
        return InterpolationHelper.replaceSupplementary((String)value, (Replacer)new Replacer(){

            public String replace(String in) {
                return UCharacter.getName((String)in, (String)", ");
            }
        });
    }

    public static String smartDateFormat(Date value, String skeleton) {
        return ICUHumanize.formatDate(value, context.get().getBestPattern(skeleton));
    }

    public static String smartDateFormat(final Date value, final String skeleton, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.smartDateFormat(value, skeleton);
            }
        }, locale);
    }

    public static String spellNumber(Number value) {
        return context.get().getRuleBasedNumberFormat(1).format((Object)value);
    }

    public static String spellNumber(final Number value, Locale locale) {
        return ICUHumanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ICUHumanize.spellNumber(value);
            }
        }, locale);
    }

    public static String transliterate(String text) {
        return ICUHumanize.transliterate(text, "Latin");
    }

    public static String transliterate(String text, String id) {
        Transliterator transliterator = Transliterator.getInstance((String)id);
        return transliterator.transform(text);
    }

    private static ContextFactory loadContextFactory() {
        ServiceLoader<ContextFactory> ldr = ServiceLoader.load(ContextFactory.class);
        for (ContextFactory factory : ldr) {
            if (!ICUContextFactory.class.isAssignableFrom(factory.getClass())) continue;
            return factory;
        }
        throw new RuntimeException("No ContextFactory was found");
    }

    private static String stripZeros(DecimalFormat decf, String fmtd) {
        char decsep = decf.getDecimalFormatSymbols().getDecimalSeparator();
        return fmtd.replaceAll("\\" + decsep + "00", "");
    }

    private static <T> T withinLocale(Callable<T> operation, Locale locale) {
        DefaultICUContext ctx = context.get();
        Locale oldLocale = ctx.getLocale();
        try {
            ctx.setLocale(locale);
            T t = operation.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ctx.setLocale(oldLocale);
            context.set(ctx);
        }
    }

    private ICUHumanize() {
    }
}

