/*
 * Decompiled with CFR 0.152.
 */
package humanize.icu.spi.context;

import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DurationFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.util.ULocale;
import humanize.icu.spi.MessageFormat;
import humanize.icu.spi.context.ICUContext;
import humanize.spi.cache.CacheProvider;
import humanize.spi.context.Context;
import humanize.text.MaskFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;

public class DefaultICUContext
implements Context,
ICUContext {
    private static final String DURATION_FORMAT = "icu.duration.format";
    private static final String CURRENCY = "icu.currency";
    private static final String DECIMAL = "icu.decimal";
    private static final String COMPACT_DECIMAL = "icu.compact.decimal";
    private static final String NUMBER = "icu.number";
    private static final String PERCENT = "icu.percent";
    private static final String RULE_BASED = "icu.rule.based";
    private static final String DATE_FORMAT = "icu.date";
    private static final String CURRENCY_PL = "icu.currency.pl";
    private static final String DATE_TIME_FORMAT = "icu.date.time";
    private static final CacheProvider sharedCache = DefaultICUContext.loadCacheProvider();
    private final CacheProvider localCache = DefaultICUContext.loadCacheProvider();
    private Locale locale;
    private ULocale ulocale;
    private MessageFormat messageFormat;

    private static CacheProvider loadCacheProvider() {
        ServiceLoader<CacheProvider> ldr = ServiceLoader.load(CacheProvider.class);
        Iterator<CacheProvider> i$ = ldr.iterator();
        if (i$.hasNext()) {
            CacheProvider provider = i$.next();
            return provider;
        }
        throw new RuntimeException("No CacheProvider was found");
    }

    public DefaultICUContext() {
        this(Locale.getDefault());
    }

    public DefaultICUContext(Locale locale) {
        this.setLocale(locale);
        this.messageFormat = new MessageFormat("", locale);
    }

    public String digitStrings(int index) {
        throw new UnsupportedOperationException("Use humanize-slim instead.");
    }

    public String formatDate(int style, Date value) {
        return this.getDateFormat(style).format(value);
    }

    public String formatDateTime(Date date) {
        return this.getDateTimeFormat().format(date);
    }

    public String formatDateTime(int dateStyle, int timeStyle, Date date) {
        return this.getDateTimeFormat(dateStyle, timeStyle).format(date);
    }

    public String formatDecimal(Number value) {
        return this.getNumberFormat().format((Object)value);
    }

    public String formatMessage(String key, Object ... args) {
        throw new UnsupportedOperationException("Use humanize-slim instead.");
    }

    @Override
    public String getBestPattern(String skeleton) {
        DateTimePatternGenerator generator = DateTimePatternGenerator.getInstance((ULocale)this.getULocale());
        return generator.getBestPattern(skeleton);
    }

    public ResourceBundle getBundle() {
        throw new UnsupportedOperationException("Please, use humanize-slim to get the bundle.");
    }

    @Override
    public NumberFormat getCompactDecimalFormat() {
        return this.getCompactDecimalFormat(CompactDecimalFormat.CompactStyle.SHORT);
    }

    @Override
    public NumberFormat getCompactDecimalFormat(final CompactDecimalFormat.CompactStyle style) {
        String compactDecKey = COMPACT_DECIMAL + style.name();
        return (NumberFormat)sharedCache.getFormat(compactDecKey, this.locale, (Callable)new Callable<NumberFormat>(){

            @Override
            public NumberFormat call() throws Exception {
                return CompactDecimalFormat.getInstance((Locale)DefaultICUContext.this.locale, (CompactDecimalFormat.CompactStyle)style);
            }
        });
    }

    @Override
    public DecimalFormat getCurrencyFormat() {
        return (DecimalFormat)sharedCache.getFormat(CURRENCY, this.locale, (Callable)new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return (DecimalFormat)NumberFormat.getCurrencyInstance((Locale)DefaultICUContext.this.locale);
            }
        });
    }

    @Override
    public DateFormat getDateFormat(final int style) {
        String name = DATE_FORMAT + style;
        return (DateFormat)this.localCache.getFormat(name, this.locale, (Callable)new Callable<DateFormat>(){

            @Override
            public DateFormat call() throws Exception {
                return DateFormat.getDateInstance((int)style, (Locale)DefaultICUContext.this.locale);
            }
        });
    }

    @Override
    public DateFormat getDateTimeFormat() {
        return this.getDateTimeFormat(3, 3);
    }

    @Override
    public DateFormat getDateTimeFormat(final int dateStyle, final int timeStyle) {
        String name = DATE_TIME_FORMAT + dateStyle + timeStyle;
        return (DateFormat)this.localCache.getFormat(name, this.locale, (Callable)new Callable<DateFormat>(){

            @Override
            public DateFormat call() throws Exception {
                return DateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (Locale)DefaultICUContext.this.locale);
            }
        });
    }

    @Override
    public DecimalFormat getDecimalFormat() {
        return (DecimalFormat)this.localCache.getFormat(DECIMAL, this.locale, (Callable)new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return (DecimalFormat)DecimalFormat.getInstance((Locale)DefaultICUContext.this.locale);
            }
        });
    }

    @Override
    public DurationFormat getDurationFormat() {
        return (DurationFormat)sharedCache.getFormat(DURATION_FORMAT, this.locale, (Callable)new Callable<DurationFormat>(){

            @Override
            public DurationFormat call() throws Exception {
                return DurationFormat.getInstance((ULocale)DefaultICUContext.this.ulocale);
            }
        });
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MaskFormat getMaskFormat() {
        throw new UnsupportedOperationException("Use humanize-slim instead.");
    }

    public String getMessage(String key) {
        throw new UnsupportedOperationException("Use humanize-slim instead.");
    }

    @Override
    public MessageFormat getMessageFormat() {
        this.messageFormat.setLocale(this.locale);
        return this.messageFormat;
    }

    @Override
    public NumberFormat getNumberFormat() {
        return (NumberFormat)sharedCache.getFormat(NUMBER, this.locale, (Callable)new Callable<NumberFormat>(){

            @Override
            public NumberFormat call() throws Exception {
                return NumberFormat.getInstance((Locale)DefaultICUContext.this.locale);
            }
        });
    }

    @Override
    public DecimalFormat getPercentFormat() {
        return (DecimalFormat)sharedCache.getFormat(PERCENT, this.locale, (Callable)new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return (DecimalFormat)NumberFormat.getPercentInstance((Locale)DefaultICUContext.this.locale);
            }
        });
    }

    @Override
    public DecimalFormat getPluralCurrencyFormat() {
        return (DecimalFormat)sharedCache.getFormat(CURRENCY_PL, this.locale, (Callable)new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return (DecimalFormat)NumberFormat.getInstance((Locale)DefaultICUContext.this.locale, (int)6);
            }
        });
    }

    @Override
    public NumberFormat getRuleBasedNumberFormat(final int type) {
        String ruleBasedName = RULE_BASED + type;
        return (NumberFormat)sharedCache.getFormat(ruleBasedName, this.locale, (Callable)new Callable<NumberFormat>(){

            @Override
            public NumberFormat call() throws Exception {
                return new RuleBasedNumberFormat(DefaultICUContext.this.locale, type);
            }
        });
    }

    @Override
    public ULocale getULocale() {
        return this.ulocale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.ulocale = ULocale.forLocale((Locale)locale);
    }
}

