/*
 * Decompiled with CFR 0.152.
 */
package humanize;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import humanize.spi.Expose;
import humanize.spi.MessageFormat;
import humanize.spi.context.ContextFactory;
import humanize.spi.context.DefaultContext;
import humanize.spi.context.DefaultContextFactory;
import humanize.text.MaskFormat;
import humanize.text.util.InterpolationHelper;
import humanize.text.util.Replacer;
import humanize.time.PrettyTimeFormat;
import humanize.util.Constants;
import java.math.BigDecimal;
import java.text.BreakIterator;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import javax.xml.bind.DatatypeConverter;

public final class Humanize {
    private static final ContextFactory contextFactory = Humanize.loadContextFactory();
    private static final ThreadLocal<DefaultContext> context = new ThreadLocal<DefaultContext>(){

        @Override
        protected DefaultContext initialValue() {
            return (DefaultContext)contextFactory.createContext();
        }
    };

    public static String binaryPrefix(Number value) {
        return Humanize.prefix(value, 1024, Constants.binPrefixes);
    }

    @Expose
    public static String binaryPrefix(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.binaryPrefix(value);
            }
        }, locale);
    }

    public static String camelize(String text) {
        return Humanize.camelize(text, false);
    }

    public static String camelize(String text, boolean capitalizeFirstChar) {
        StringBuilder sb = new StringBuilder();
        String[] tokens = text.split("[\\.\\s_-]+");
        if (tokens.length < 2) {
            return capitalizeFirstChar ? Humanize.capitalize(text) : text;
        }
        for (String token : tokens) {
            sb.append(Humanize.capitalize(token));
        }
        return capitalizeFirstChar ? sb.toString() : sb.substring(0, 1).toLowerCase(context.get().getLocale()) + sb.substring(1);
    }

    public static String camelize(final String text, final boolean capitalizeFirstChar, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.camelize(text, capitalizeFirstChar);
            }
        }, locale);
    }

    @Expose
    public static String camelize(String text, Locale locale) {
        return Humanize.camelize(text, false, locale);
    }

    public static String capitalize(String word) {
        if (word.length() == 0) {
            return word;
        }
        Locale locale = context.get().getLocale();
        return word.substring(0, 1).toUpperCase(locale) + word.substring(1).toLowerCase(locale);
    }

    @Expose
    public static String capitalize(final String word, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.capitalize(word);
            }
        }, locale);
    }

    public static DateFormat dateFormat(String pattern) {
        return context.get().getDateFormat(pattern);
    }

    public static DateFormat dateFormat(final String pattern, Locale locale) {
        return Humanize.withinLocale(new Callable<DateFormat>(){

            @Override
            public DateFormat call() throws Exception {
                return Humanize.dateFormat(pattern);
            }
        }, locale);
    }

    @Expose
    public static String decamelize(String words) {
        return Constants.SPLIT_CAMEL.matcher(words).replaceAll(" ");
    }

    public static String decamelize(String words, String replacement) {
        return Constants.SPLIT_CAMEL.matcher(words).replaceAll(replacement);
    }

    public static DecimalFormat decimalFormat(String pattern) {
        DecimalFormat decFmt = context.get().getDecimalFormat();
        decFmt.applyPattern(pattern);
        return decFmt;
    }

    public static DecimalFormat decimalFormat(final String pattern, Locale locale) {
        return Humanize.withinLocale(new Callable<DecimalFormat>(){

            @Override
            public DecimalFormat call() throws Exception {
                return Humanize.decimalFormat(pattern);
            }
        }, locale);
    }

    public static String duration(Number seconds) {
        return Humanize.duration(seconds, Constants.TimeStyle.STANDARD);
    }

    public static String duration(final Number seconds, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.duration(seconds);
            }
        }, locale);
    }

    public static String duration(Number seconds, Constants.TimeStyle style) {
        int s = seconds.intValue();
        return style.format(context.get(), s / 3600 % 60, s / 60 % 60, s % 60);
    }

    public static String duration(final Number seconds, final Constants.TimeStyle style, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.duration(seconds, style);
            }
        }, locale);
    }

    public static String fixLength(String text, int charsNum, char paddingChar) {
        return Humanize.fixLength(text, charsNum, paddingChar, false);
    }

    public static String fixLength(String text, int charsNum, char paddingChar, boolean left) {
        Preconditions.checkArgument((charsNum > 0 ? 1 : 0) != 0, (Object)"The number of characters must be greater than zero.");
        String str = text == null ? "" : text;
        String fmt = String.format("%%%ss", left ? charsNum : -charsNum);
        return String.format(fmt, str).substring(0, charsNum).replace(' ', paddingChar);
    }

    public static String format(String pattern, Object ... args) {
        return Humanize.messageFormat(pattern).render(args);
    }

    public static String formatCurrency(Number value) {
        DecimalFormat decf = context.get().getCurrencyFormat();
        return Humanize.stripZeros(decf, decf.format(value));
    }

    public static String formatCurrency(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.formatCurrency(value);
            }
        }, locale);
    }

    public static String formatDate(Date value) {
        return Humanize.formatDate(3, value);
    }

    public static String formatDate(final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDate(value);
            }
        }, locale);
    }

    public static String formatDate(Date value, String pattern) {
        return new SimpleDateFormat(pattern, context.get().getLocale()).format(value);
    }

    public static String formatDate(final Date value, final String pattern, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDate(value, pattern);
            }
        }, locale);
    }

    public static String formatDate(int style, Date value) {
        return context.get().formatDate(style, value);
    }

    public static String formatDate(final int style, final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDate(style, value);
            }
        }, locale);
    }

    public static String formatDateTime(Date value) {
        return context.get().formatDateTime(value);
    }

    public static String formatDateTime(final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDateTime(value);
            }
        }, locale);
    }

    public static String formatDateTime(int dateStyle, int timeStyle, Date value) {
        return context.get().formatDateTime(dateStyle, timeStyle, value);
    }

    public static String formatDateTime(final int dateStyle, final int timeStyle, final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatDateTime(dateStyle, timeStyle, value);
            }
        }, locale);
    }

    public static String formatDecimal(Number value) {
        return context.get().formatDecimal(value);
    }

    public static String formatDecimal(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.formatDecimal(value);
            }
        }, locale);
    }

    public static String formatPercent(Number value) {
        return context.get().getPercentFormat().format(value);
    }

    public static String formatPercent(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.formatPercent(value);
            }
        }, locale);
    }

    public static String mask(String mask, String value) {
        return Humanize.maskFormat(mask).format(value);
    }

    public static MaskFormat maskFormat(String mask) {
        MaskFormat maskFmt = context.get().getMaskFormat();
        maskFmt.setMask(mask);
        return maskFmt;
    }

    public static MessageFormat messageFormat(String pattern) {
        MessageFormat msg = context.get().getMessageFormat();
        msg.applyPattern(pattern);
        return msg;
    }

    public static MessageFormat messageFormat(final String pattern, Locale locale) {
        return Humanize.withinLocale(new Callable<MessageFormat>(){

            @Override
            public MessageFormat call() throws Exception {
                return Humanize.messageFormat(pattern);
            }
        }, locale);
    }

    public static String metricPrefix(Number value) {
        return Humanize.prefix(value, 1000, Constants.metricPrefixes);
    }

    @Expose
    public static String metricPrefix(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.metricPrefix(value);
            }
        }, locale);
    }

    public static String nanoTime(Number value) {
        return Humanize.prefix(value, 1000, Constants.nanoTimePrefixes);
    }

    @Expose
    public static String nanoTime(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.prefix(value, 1000, Constants.nanoTimePrefixes);
            }
        }, locale);
    }

    public static String naturalDay(Date value) {
        return Humanize.naturalDay(3, value);
    }

    @Expose
    public static String naturalDay(Date value, Locale locale) {
        return Humanize.naturalDay(3, value, locale);
    }

    public static String naturalDay(int style, Date value) {
        Date today = new Date();
        long delta = value.getTime() - today.getTime();
        long days = delta / 82800000L;
        if (days == 0L) {
            return context.get().getMessage("today");
        }
        if (days == 1L) {
            return context.get().getMessage("tomorrow");
        }
        if (days == -1L) {
            return context.get().getMessage("yesterday");
        }
        return Humanize.formatDate(style, value);
    }

    public static String naturalDay(final int style, final Date value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.naturalDay(style, value);
            }
        }, locale);
    }

    public static String naturalTime(Date duration) {
        return context.get().formatRelativeDate(duration);
    }

    public static String naturalTime(Date reference, Date duration) {
        return context.get().formatRelativeDate(reference, duration);
    }

    public static String naturalTime(final Date reference, final Date duration, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.naturalTime(reference, duration);
            }
        }, locale);
    }

    @Expose
    public static String naturalTime(Date duration, Locale locale) {
        return Humanize.naturalTime(new Date(), duration, locale);
    }

    public static String ordinal(Number value) {
        int v = value.intValue();
        int vc = v % 100;
        if (vc > 10 && vc < 14) {
            return String.format("%d%s", v, context.get().ordinalSuffix(0));
        }
        return String.format("%d%s", v, context.get().ordinalSuffix(v % 10));
    }

    @Expose
    public static String ordinal(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.ordinal(value);
            }
        }, locale);
    }

    public static byte[] parseBase64(String base64str) {
        return DatatypeConverter.parseBase64Binary((String)base64str);
    }

    public static Date parseISODate(String dateStr) {
        return DatatypeConverter.parseDate((String)dateStr).getTime();
    }

    public static Date parseISODateTime(String dateStr) {
        return DatatypeConverter.parseDateTime((String)dateStr).getTime();
    }

    public static Date parseISOTime(String timeStr) {
        return DatatypeConverter.parseTime((String)timeStr).getTime();
    }

    public static Date parseSmartDate(String dateStr, String ... fmts) {
        return Humanize.parseSmartDateWithSeparator(dateStr, "[\\D-_\\s]+", fmts);
    }

    public static Date parseSmartDateWithSeparator(String dateStr, String separator, String ... fmts) {
        dateStr = dateStr.replaceAll(separator, "/");
        for (String fmt : fmts) {
            try {
                DateFormat df = Humanize.dateFormat(fmt);
                df.setLenient(false);
                return df.parse(dateStr);
            }
            catch (ParseException ignored) {
            }
        }
        throw new IllegalArgumentException("Unable to parse date '" + dateStr + "'");
    }

    public static String pluralize(Locale locale, final String one, final String many, final Number n, final Object ... exts) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.pluralize(one, many, n, exts);
            }
        }, locale);
    }

    public static String pluralize(Locale locale, final String one, final String many, final String none, final Number n, final Object ... exts) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Humanize.pluralize(one, many, none, n, exts);
            }
        }, locale);
    }

    public static String pluralize(String one, String many, Number n, Object ... exts) {
        Object[] objectArray;
        MessageFormat format = Humanize.pluralizeFormat("{0}", many, one, many);
        if (exts == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = n;
        } else {
            objectArray = ObjectArrays.concat((Object)n, (Object[])exts);
        }
        Object[] params = objectArray;
        return format.render(params);
    }

    public static String pluralize(String one, String many, String none, Number n, Object ... exts) {
        Object[] objectArray;
        MessageFormat format = Humanize.pluralizeFormat("{0}", none, one, many);
        if (exts == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = n;
        } else {
            objectArray = ObjectArrays.concat((Object)n, (Object[])exts);
        }
        Object[] params = objectArray;
        return format.render(params);
    }

    public static MessageFormat pluralizeFormat(String template) {
        String[] tokens = template.split("\\s*\\:{2}\\s*");
        if (tokens.length < 4) {
            if (tokens.length == 2) {
                tokens = new String[]{"{0}", tokens[1], tokens[0], tokens[1]};
            } else if (tokens.length == 3) {
                tokens = new String[]{"{0}", tokens[0], tokens[1], tokens[2]};
            } else {
                throw new IllegalArgumentException(String.format("Template '%s' must declare at least 2 tokens. V.gr. 'one thing::{0} things'", template));
            }
        }
        return Humanize.pluralizeFormat(tokens[0], Arrays.copyOfRange(tokens, 1, tokens.length));
    }

    public static MessageFormat pluralizeFormat(final String template, Locale locale) {
        return Humanize.withinLocale(new Callable<MessageFormat>(){

            @Override
            public MessageFormat call() throws Exception {
                return Humanize.pluralizeFormat(template);
            }
        }, locale);
    }

    public static MessageFormat pluralizeFormat(String pattern, String ... choices) {
        double[] indexes = new double[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            indexes[i] = i;
        }
        ChoiceFormat choiceForm = new ChoiceFormat(indexes, choices);
        MessageFormat format = (MessageFormat)Humanize.messageFormat(pattern).clone();
        format.setFormat(0, choiceForm);
        return format;
    }

    public static PrettyTimeFormat prettyTimeFormat() {
        return context.get().getPrettyTimeFormat();
    }

    public static PrettyTimeFormat prettyTimeFormat(Locale locale) {
        return Humanize.withinLocale(new Callable<PrettyTimeFormat>(){

            @Override
            public PrettyTimeFormat call() throws Exception {
                return ((DefaultContext)context.get()).getPrettyTimeFormat();
            }
        }, locale);
    }

    @Expose
    public static String replaceSupplementary(String value) {
        return InterpolationHelper.replaceSupplementary(value, new Replacer(){

            @Override
            public String replace(String in) {
                StringBuilder uc = new StringBuilder();
                for (char c : in.toCharArray()) {
                    uc.append("\\\\u");
                    uc.append(Integer.toHexString(c).toUpperCase());
                }
                return uc.toString();
            }
        });
    }

    @Expose
    public static String slugify(String text) {
        String result = Humanize.transliterate(text);
        result = Constants.ONLY_SLUG_CHARS.matcher(result).replaceAll("");
        result = CharMatcher.WHITESPACE.trimFrom((CharSequence)result);
        result = Constants.HYPEN_SPACE.matcher(result).replaceAll("-");
        return result.toLowerCase();
    }

    public static String spellBigNumber(Number value) {
        BigDecimal v = new BigDecimal(value.toString());
        if (Constants.THOUSAND.compareTo(v.abs()) > 0) {
            return value.toString();
        }
        boolean isPlural = Humanize.needPlural(v.unscaledValue().intValue());
        for (BigDecimal bigNum : Constants.bigDecExponents.keySet()) {
            if (bigNum.multiply(Constants.THOUSAND).compareTo(v.abs()) <= 0) continue;
            return context.get().formatMessage(isPlural ? Constants.bigDecExponents.get(bigNum) + ".pl" : Constants.bigDecExponents.get(bigNum), v.divide(bigNum));
        }
        return value.toString();
    }

    @Expose
    public static String spellBigNumber(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.spellBigNumber(value);
            }
        }, locale);
    }

    public static String spellDigit(Number value) {
        int v = value.intValue();
        if (v < 0 || v > 9) {
            return value.toString();
        }
        return context.get().digitStrings(v);
    }

    @Expose
    public static String spellDigit(final Number value, Locale locale) {
        return Humanize.withinLocale(new Callable<String>(){

            @Override
            public String call() {
                return Humanize.spellDigit(value);
            }
        }, locale);
    }

    @Expose
    public static String titleize(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        boolean capitalize = true;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                sb.append(' ');
                capitalize = true;
                continue;
            }
            if (ch == '_') {
                sb.append(' ');
                capitalize = true;
                continue;
            }
            if (capitalize) {
                sb.append(Character.toUpperCase(ch));
                capitalize = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Expose
    public static String transliterate(String text) {
        String normalized = Normalizer.normalize(text, Normalizer.Form.NFD);
        return normalized.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    @Expose
    public static String underscore(String text) {
        return text.replaceAll("\\s+", "_");
    }

    public static String unmask(String mask, String value) throws ParseException {
        return Humanize.maskFormat(mask).parse(value);
    }

    public static String wordWrap(String value, int len) {
        if (len < 0 || value.length() <= len) {
            return value;
        }
        BreakIterator bi = BreakIterator.getWordInstance(context.get().getLocale());
        bi.setText(value);
        return value.substring(0, bi.following(len));
    }

    private static ContextFactory loadContextFactory() {
        ServiceLoader<ContextFactory> ldr = ServiceLoader.load(ContextFactory.class);
        for (ContextFactory factory : ldr) {
            if (!DefaultContextFactory.class.isAssignableFrom(factory.getClass())) continue;
            return factory;
        }
        throw new RuntimeException("No ContextFactory was found");
    }

    private static boolean needPlural(int n) {
        int tmp = 0;
        for (int an = Math.abs(n); an > 0; an /= 10) {
            tmp = an % 10;
            if (tmp <= 1) continue;
            return true;
        }
        return false;
    }

    private static String prefix(Number value, int min, Map<Long, String> prefixes) {
        DecimalFormat df = context.get().getDecimalFormat();
        long v = value.longValue();
        if (v < 0L) {
            return value.toString();
        }
        for (Long num : prefixes.keySet()) {
            if (num > v) continue;
            df.applyPattern(prefixes.get(num));
            return Humanize.stripZeros(df, df.format(v >= (long)min ? (double)((float)v / (float)num.longValue()) : (double)v));
        }
        return Humanize.stripZeros(df, df.format(value.toString()));
    }

    private static String stripZeros(DecimalFormat decf, String fmtd) {
        char decsep = decf.getDecimalFormatSymbols().getDecimalSeparator();
        return fmtd.replaceAll("\\" + decsep + "00", "");
    }

    private static <T> T withinLocale(Callable<T> operation, Locale locale) {
        DefaultContext ctx = context.get();
        Locale oldLocale = ctx.getLocale();
        try {
            ctx.setLocale(locale);
            T t = operation.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ctx.setLocale(oldLocale);
            context.set(ctx);
        }
    }

    private Humanize() {
    }
}

