/*
 * Decompiled with CFR 0.152.
 */
package humanize.text;

import humanize.spi.MessageFormat;
import humanize.text.util.InterpolationHelper;
import humanize.text.util.Replacer;
import java.util.regex.Pattern;

public final class EmojiInterpolator {
    public static final Pattern EMOJI_ALIAS = Pattern.compile(":(bowtie|smile|blush|smiley|relaxed|smirk|heart_eyes|kissing_heart|kissing_face|flushed|relieved|satisfied|grin|wink|wink2|tongue|unamused|sweat|pensive|disappointed|confounded|fearful|cold_sweat|persevere|cry|sob|joy|astonished|scream|angry|rage|sleepy|mask|imp|alien|yellow_heart|blue_heart|purple_heart|heart|green_heart|broken_heart|heartbeat|heartpulse|cupid|sparkles|star|star2|anger|exclamation|question|grey_exclamation|grey_question|zzz|dash|sweat_drops|notes|musical_note|fire|hankey|poop|shit|\\+1|thumbsup|-1|thumbsdown|ok_hand|punch|fist|v|wave|hand|open_hands|point_up|point_down|point_left|point_right|raised_hands|pray|point_up_2|clap|muscle|metal|walking|runner|couple|dancer|dancers|ok_woman|no_good|information_desk_person|bow|couplekiss|couple_with_heart|massage|haircut|nail_care|boy|girl|woman|man|baby|older_woman|older_man|person_with_blond_hair|man_with_gua_pi_mao|man_with_turban|construction_worker|cop|angel|princess|guardsman|skull|feet|lips|kiss|ear|eyes|nose|feelsgood|finnadie|goberserk|godmode|hurtrealbad|rage1|rage2|rage3|rage4|suspect|trollface|sunny|umbrella|cloud|snowman|moon|zap|cyclone|ocean|cat|dog|mouse|hamster|rabbit|wolf|frog|tiger|koala|bear|pig|cow|boar|monkey_face|monkey|horse|racehorse|camel|sheep|elephant|snake|bird|baby_chick|chicken|penguin|bug|octopus|tropical_fish|fish|whale|dolphin|bouquet|cherry_blossom|tulip|four_leaf_clover|rose|sunflower|hibiscus|maple_leaf|leaves|fallen_leaf|palm_tree|cactus|ear_of_rice|shell|octocat|squirrel|bamboo|gift_heart|dolls|school_satchel|mortar_board|flags|fireworks|sparkler|wind_chime|rice_scene|jack_o_lantern|ghost|santa|christmas_tree|gift|bell|tada|balloon|cd|dvd|camera|movie_camera|computer|tv|iphone|fax|phone|telephone|minidisc|vhs|speaker|loudspeaker|mega|radio|satellite|loop|mag|unlock|lock|key|scissors|hammer|bulb|calling|email|mailbox|postbox|bath|toilet|seat|moneybag|trident|smoking|bomb|gun|pill|syringe|football|basketball|soccer|baseball|tennis|golf|8ball|swimmer|surfer|ski|spades|hearts|clubs|diamonds|gem|ring|trophy|space_invader|dart|mahjong|clapper|memo|pencil|book|art|microphone|headphones|trumpet|saxophone|guitar|part_alternation_mark|shoe|sandal|high_heel|lipstick|boot|shirt|tshirt|necktie|dress|kimono|bikini|ribbon|tophat|crown|womans_hat|closed_umbrella|briefcase|handbag|beer|beers|cocktail|sake|fork_and_knife|hamburger|fries|spaghetti|curry|bento|sushi|rice_ball|rice_cracker|rice|ramen|stew|bread|egg|oden|dango|icecream|shaved_ice|birthday|cake|apple|tangerine|watermelon|strawberry|eggplant|tomato|coffee|tea|109|house|school|office|post_office|hospital|bank|convenience_store|love_hotel|hotel|wedding|church|department_store|city_sunrise|city_sunset|japanese_castle|european_castle|tent|factory|tokyo_tower|mount_fuji|sunrise_over_mountains|sunrise|stars|statue_of_liberty|rainbow|ferris_wheel|fountain|roller_coaster|ship|speedboat|boat|sailboat|airplane|rocket|bike|blue_car|car|red_car|taxi|bus|police_car|fire_engine|ambulance|truck|train|station|bullettrain_front|bullettrain_side|ticket|fuelpump|traffic_light|warning|construction|beginner|atm|slot_machine|busstop|barber|hotsprings|checkered_flag|crossed_flags|jp|kr|cn|us|fr|es|it|ru|gb|de|one|two|three|four|five|six|seven|eight|nine|zero|hash|arrow_backward|arrow_down|arrow_forward|arrow_left|arrow_lower_left|arrow_lower_right|arrow_right|arrow_up|arrow_upper_left|arrow_upper_right|rewind|fast_forward|ok|new|top|up|cool|cinema|koko|signal_strength|u5272|u55b6|u6307|u6708|u6709|u6e80|u7121|u7533|u7a7a|sa|restroom|mens|womens|baby_symbol|no_smoking|parking|wheelchair|metro|wc|secret|congratulations|ideograph_advantage|underage|id|eight_spoked_asterisk|eight_pointed_black_star|heart_decoration|vs|vibration_mode|mobile_phone_off|chart|currency_exchange|aries|taurus|gemini|cancer|leo|virgo|libra|scorpius|sagittarius|capricorn|aquarius|pisces|ophiuchus|six_pointed_star|a|b|ab|o2|red_circle|black_square|white_square|clock1|clock10|clock11|clock12|clock2|clock3|clock4|clock5|clock6|clock7|clock8|clock9|o|x|copyright|registered|tm|shipit):");
    public static final Pattern EMOJI_UCHARS = Pattern.compile("(\ue415|\ue056|\ue057|\ue414|\ue405|\ue106|\ue418|\ue417|\ue40d|\ue40a|\ue404|\ue105|\ue409|\ue40e|\ue402|\ue108|\ue403|\ue058|\ue407|\ue401|\ue40f|\ue40b|\ue406|\ue413|\ue411|\ue412|\ue410|\ue107|\ue059|\ue416|\ue408|\ue40c|\ue11a|\ue10c|\ue32c|\ue32a|\ue32d|\ue328|\ue32b|\ue022|\ue023|\ue327|\ue329|\ue32e|\ue32f|\ue335|\ue334|\ue021|\ue337|\ue020|\ue336|\ue13c|\ue330|\ue331|\ue326|\ue03e|\ue11d|\ue05a|\ue00e|\ue421|\ue420|\ue00d|\ue010|\ue011|\ue41e|\ue012|\ue422|\ue22e|\ue22f|\ue231|\ue230|\ue427|\ue41d|\ue00f|\ue41f|\ue14c|\ue201|\ue115|\ue428|\ue51f|\ue429|\ue424|\ue423|\ue253|\ue426|\ue111|\ue425|\ue31e|\ue31f|\ue31d|\ue001|\ue002|\ue005|\ue004|\ue51a|\ue519|\ue518|\ue515|\ue516|\ue517|\ue51b|\ue152|\ue04e|\ue51c|\ue51e|\ue11c|\ue536|\ue003|\ue41c|\ue41b|\ue419|\ue41a|\ue04a|\ue04b|\ue049|\ue048|\ue04c|\ue13d|\ue443|\ue43e|\ue04f|\ue052|\ue053|\ue524|\ue52c|\ue52a|\ue531|\ue050|\ue527|\ue051|\ue10b|\ue52b|\ue52f|\ue528|\ue01a|\ue134|\ue530|\ue529|\ue526|\ue52d|\ue521|\ue523|\ue52e|\ue055|\ue525|\ue10a|\ue109|\ue522|\ue019|\ue054|\ue520|\ue306|\ue030|\ue304|\ue110|\ue032|\ue305|\ue303|\ue118|\ue447|\ue119|\ue307|\ue308|\ue444|\ue441|\ue036|\ue157|\ue038|\ue153|\ue155|\ue14d|\ue156|\ue501|\ue158|\ue43d|\ue037|\ue504|\ue44a|\ue146|\ue50a|\ue505|\ue506|\ue122|\ue508|\ue509|\ue03b|\ue04d|\ue449|\ue44b|\ue51d|\ue44c|\ue124|\ue121|\ue433|\ue202|\ue135|\ue01c|\ue01d|\ue10d|\ue136|\ue42e|\ue01b|\ue15a|\ue159|\ue432|\ue430|\ue431|\ue42f|\ue01e|\ue039|\ue435|\ue01f|\ue125|\ue03a|\ue14e|\ue252|\ue137|\ue209|\ue154|\ue133|\ue150|\ue320|\ue123|\ue132|\ue143|\ue50b|\ue514|\ue513|\ue50c|\ue50d|\ue511|\ue50f|\ue512|\ue510|\ue50e|\ue436|\ue437|\ue438|\ue43a|\ue439|\ue43b|\ue117|\ue440|\ue442|\ue446|\ue445|\ue11b|\ue448|\ue033|\ue112|\ue325|\ue312|\ue310|\ue126|\ue127|\ue008|\ue03d|\ue00c|\ue12a|\ue00a|\ue00b|\ue009|\ue316|\ue129|\ue141|\ue142|\ue317|\ue128|\ue14b|\ue211|\ue114|\ue145|\ue144|\ue03f|\ue313|\ue116|\ue10f|\ue104|\ue103|\ue101|\ue102|\ue13f|\ue140|\ue11f|\ue12f|\ue031|\ue30e|\ue311|\ue113|\ue30f|\ue13b|\ue42b|\ue42a|\ue018|\ue016|\ue015|\ue014|\ue42c|\ue42d|\ue017|\ue013|\ue20e|\ue20c|\ue20f|\ue20d|\ue131|\ue12b|\ue130|\ue12d|\ue324|\ue301|\ue148|\ue502|\ue03c|\ue30a|\ue042|\ue040|\ue041|\ue12c|\ue007|\ue31a|\ue13e|\ue31b|\ue006|\ue302|\ue319|\ue321|\ue322|\ue314|\ue503|\ue10e|\ue318|\ue43c|\ue11e|\ue323|\ue31c|\ue034|\ue035|\ue045|\ue338|\ue047|\ue30c|\ue044|\ue30b|\ue043|\ue120|\ue33b|\ue33f|\ue341|\ue34c|\ue344|\ue342|\ue33d|\ue33e|\ue340|\ue34d|\ue339|\ue147|\ue343|\ue33c|\ue33a|\ue43f|\ue34b|\ue046|\ue345|\ue346|\ue348|\ue347|\ue34a|\ue349|\ue21c|\ue21d|\ue21e|\ue21f|\ue220|\ue221|\ue222|\ue223|\ue224|\ue225|\ue210|\ue232|\ue233|\ue235|\ue234|\ue236|\ue237|\ue238|\ue239|\ue23b|\ue23a|\ue23d|\ue23c|\ue24d|\ue212|\ue24c|\ue213|\ue214|\ue507|\ue203|\ue20b|\ue22a|\ue22b|\ue226|\ue227|\ue22c|\ue22d|\ue215|\ue216|\ue217|\ue218|\ue228|\ue151|\ue138|\ue139|\ue13a|\ue208|\ue14f|\ue20a|\ue434|\ue309|\ue315|\ue30d|\ue207|\ue229|\ue206|\ue205|\ue204|\ue12e|\ue250|\ue251|\ue14a|\ue149|\ue23f|\ue240|\ue241|\ue242|\ue243|\ue244|\ue245|\ue246|\ue247|\ue248|\ue249|\ue24a|\ue24b|\ue23e|\ue532|\ue533|\ue534|\ue535|\ue21a|\ue219|\ue21b|\ue02f|\ue024|\ue025|\ue026|\ue027|\ue028|\ue029|\ue02a|\ue02b|\ue02c|\ue02d|\ue02e|\ue332|\ue333|\ue24e|\ue24f|\ue537)");

    public static String interpolateAlias(String pattern, String text) {
        return InterpolationHelper.interpolate(text, EMOJI_ALIAS, new EmojiAliasInterpolator(pattern));
    }

    public static String interpolateChars(String pattern, String text) {
        return InterpolationHelper.interpolate(text, EMOJI_UCHARS, new EmojiCharInterpolator(pattern));
    }

    private EmojiInterpolator() {
    }

    static class EmojiCharInterpolator
    implements Replacer {
        private final MessageFormat msgFormat;

        public EmojiCharInterpolator(String pattern) {
            this.msgFormat = new MessageFormat(pattern);
        }

        @Override
        public String replace(String in) {
            StringBuilder uc = new StringBuilder();
            for (char c : in.toCharArray()) {
                uc.append('u');
                uc.append(Integer.toHexString(c).toUpperCase());
            }
            return this.msgFormat.render(uc.toString());
        }
    }

    static class EmojiAliasInterpolator
    implements Replacer {
        private final MessageFormat msgFormat;

        public EmojiAliasInterpolator(String pattern) {
            this.msgFormat = new MessageFormat(pattern);
        }

        @Override
        public String replace(String text) {
            return this.msgFormat.render(text);
        }
    }
}

