/*
 * Decompiled with CFR 0.152.
 */
package humanize.util;

import com.google.common.base.Preconditions;
import humanize.time.TimeMillis;

public final class Parameters {
    private Parameters() {
    }

    public static final class SlugifyParams {
        public String separator = "-";
        public boolean isToLowerCase = true;

        public static SlugifyParams begin() {
            return new SlugifyParams();
        }

        private SlugifyParams() {
        }

        public SlugifyParams separator(String separator) {
            this.separator = separator;
            return this;
        }

        public SlugifyParams toLowerCase(boolean isToLowerCase) {
            this.isToLowerCase = isToLowerCase;
            return this;
        }
    }

    public static final class PluralizeParams {
        public String one;
        public String many;
        public String none;
        public Object[] exts;

        public static PluralizeParams begin(String one) {
            PluralizeParams p = new PluralizeParams();
            return p.one(one);
        }

        private PluralizeParams() {
        }

        public PluralizeParams exts(Object ... exts) {
            this.exts = exts;
            return this;
        }

        public PluralizeParams many(String many) {
            this.many = many;
            return this;
        }

        public PluralizeParams none(String none) {
            this.none = none;
            return this;
        }

        public PluralizeParams one(String one) {
            this.one = one;
            return this;
        }
    }

    public static final class PaceParameters {
        public PluralizeParams plural;
        public long interval;

        public static PaceParameters begin(String one) {
            PaceParameters p = new PaceParameters();
            return p.one(one);
        }

        private PaceParameters() {
        }

        public void checkArguments() {
            Preconditions.checkArgument((this.plural != null ? 1 : 0) != 0, (Object)"Plural parameters are required");
        }

        public PaceParameters exts(Object ... exts) {
            this.plural.exts(exts);
            return this;
        }

        public PaceParameters interval(long interval) {
            this.interval = interval;
            return this;
        }

        public PaceParameters interval(TimeMillis interval) {
            this.interval = interval.millis();
            return this;
        }

        public PaceParameters many(String many) {
            this.plural.many(many);
            return this;
        }

        public PaceParameters none(String none) {
            this.plural.none(none);
            return this;
        }

        public PaceParameters one(String one) {
            this.plural = PluralizeParams.begin(one);
            return this;
        }

        public PaceParameters plural(PluralizeParams plural) {
            this.plural = plural;
            return this;
        }
    }
}

