/*
 * Decompiled with CFR 0.152.
 */
package com.mg.framework.cache;

import com.mg.framework.cache.CacheProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.springframework.core.io.Resource;

public class EhcacheCacheProvider
implements CacheProvider {
    private CacheManager cacheManager;
    private String cacheName;
    private Cache cache;
    private Resource configLocation;

    @Override
    public void put(String key, Serializable cacheObject) {
        this.cache.put(new Element((Serializable)((Object)key), cacheObject));
    }

    @Override
    public Serializable get(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        return element != null ? element.getValue() : null;
    }

    @Override
    public void remove(String key) {
        this.cache.remove((Serializable)((Object)key));
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public Resource getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    @PostConstruct
    public void postCacheManager() throws IOException, CacheException {
        try (InputStream is = this.configLocation != null ? this.configLocation.getInputStream() : null;){
            Configuration configuration = is != null ? ConfigurationFactory.parseConfiguration((InputStream)is) : ConfigurationFactory.parseConfiguration();
            this.cacheManager = this.cacheManager != null ? this.cacheManager : new CacheManager(configuration);
        }
        if (this.cacheManager == null) {
            throw new CacheException("cache manager\u521d\u59cb\u5316\u5931\u8d25");
        }
        this.cache = this.cacheManager.getCache(this.cacheName);
        if (this.cache == null) {
            throw new CacheException("cache manager\u521d\u59cb\u5316\u5931\u8d25");
        }
    }
}

