/*
 * Decompiled with CFR 0.152.
 */
package com.mg.framework.exception;

import com.alibaba.fastjson.JSON;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractView;

public class ExceptionHandler
implements HandlerExceptionResolver {
    private static Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ModelAndView mv = new ModelAndView();
        mv.setView((View)new AbstractView(){

            protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
                String str = JSON.toJSONString(model, (boolean)false);
                PrintWriter out = response.getWriter();
                out.print(str);
            }
        });
        ModelMap modelMap = mv.getModelMap();
        modelMap.clear();
        String stackTrace = ExceptionHandler.getStackTrace(ex);
        logger.error(stackTrace);
        modelMap.addAttribute("errorCode", (Object)"2015516102136");
        modelMap.addAttribute("errorText", (Object)ExceptionHandler.htmlEncode(stackTrace));
        return mv;
    }

    public static String htmlEncode(String s) {
        if (s != null) {
            s = s.replaceAll("<", "&lt;");
            s = s.replaceAll(">", "&gt;");
        }
        return s;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

