/*
 * Decompiled with CFR 0.152.
 */
package com.mg.framework.log;

import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastjsonSimpleFilter
implements PropertyPreFilter,
ExtraProcessor,
PropertyFilter {
    private static Logger logger = LoggerFactory.getLogger(FastjsonSimpleFilter.class);
    protected String[] excludeObjectNames = null;
    protected List<Relation> relations = new ArrayList<Relation>();
    protected String excludeObjectClassName = null;

    public FastjsonSimpleFilter() {
    }

    public FastjsonSimpleFilter(String inputFilterPropertyNames) {
        if (inputFilterPropertyNames == null) {
            return;
        }
        this.excludeObjectNames = inputFilterPropertyNames.split(";");
    }

    public FastjsonSimpleFilter(String[] inputFilterPropertyNames) {
        if (inputFilterPropertyNames == null) {
            return;
        }
        this.excludeObjectNames = inputFilterPropertyNames;
    }

    public boolean apply(JSONSerializer serializer, Object object, String name) {
        return true;
    }

    protected boolean isMatchExcludeObjectAndName(Object object, String name) {
        if (this.excludeObjectNames != null) {
            for (String propertyName : this.excludeObjectNames) {
                if (StringUtils.isBlank((CharSequence)propertyName)) continue;
                if (propertyName.indexOf(".") > 0) {
                    String[] s = propertyName.split("\\.");
                    if (!object.getClass().toString().endsWith(s[0]) || !name.startsWith(s[1])) continue;
                    return true;
                }
                if (!name.startsWith(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    public void processExtra(Object object, String key, Object value) {
        String[] elems = key.split("_");
        for (int i = 0; i < elems.length; ++i) {
            elems[i] = elems[i].toLowerCase();
            if (i == 0) continue;
            String elem = elems[i];
            char first = elem.toCharArray()[0];
            elems[i] = "" + (char)(first - 32) + elem.substring(1);
        }
        StringBuilder sb = new StringBuilder();
        for (String e : elems) {
            sb.append(e);
        }
        key = elems.toString();
    }

    public boolean apply(Object object, String name, Object value) {
        if (value instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)value).getHibernateLazyInitializer();
            if (initializer.isUninitialized()) {
                return false;
            }
        } else if (value instanceof PersistentCollection) {
            PersistentCollection collection = (PersistentCollection)value;
            if (!collection.wasInitialized()) {
                return false;
            }
            Object val = collection.getValue();
            if (val == null) {
                return false;
            }
        }
        return !this.isMatchExcludeObjectAndName(object, name);
    }

    class Relation {
        Object A;
        Object B;

        Relation() {
        }

        Relation(Object a, Object b) {
            this.A = a;
            this.B = b;
        }

        public Object getA() {
            return this.A;
        }

        public void setA(Object a) {
            this.A = a;
        }

        public Object getB() {
            return this.B;
        }

        public void setB(Object b) {
            this.B = b;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.A.getClass().getName());
            sb.append(" -> ");
            sb.append(this.B.getClass().getName());
            return sb.toString();
        }
    }
}

