/*
 * Decompiled with CFR 0.152.
 */
package com.mg.framework.sys;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class PropertyConfigurer
extends PropertyPlaceholderConfigurer {
    private static Map<String, Object> ctxPropMap;
    private static Logger logger;

    public static Object getContextProperty(String name) {
        return ctxPropMap.get(name);
    }

    public static String getConfig(String key) {
        return (String)ctxPropMap.get(key);
    }

    public static Map<String, Object> getConfigurer() {
        return ctxPropMap;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        super.processProperties(beanFactory, props);
        ctxPropMap = new HashMap<String, Object>();
        for (Object key : props.keySet()) {
            String keyStr = key.toString();
            String value = props.getProperty(keyStr);
            ctxPropMap.put(keyStr, value);
        }
    }

    static {
        logger = LoggerFactory.getLogger(PropertyConfigurer.class);
    }
}

