/*
 * Decompiled with CFR 0.152.
 */
package com.mg.framework.utils;

import com.mg.framework.model.BaseInnerEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnumFactory {
    private static Logger logger = LoggerFactory.getLogger(EnumFactory.class);
    private static Map<Class<? extends BaseInnerEnum>, BaseInnerEnum> innerEnumMap = new HashMap<Class<? extends BaseInnerEnum>, BaseInnerEnum>();

    private EnumFactory() {
    }

    public static void register(BaseInnerEnum tmsBaseInnerEnum) {
        innerEnumMap.put(tmsBaseInnerEnum.getClass(), tmsBaseInnerEnum);
    }

    public static BaseInnerEnum getEnum(Class<? extends BaseInnerEnum> cls) {
        if (!innerEnumMap.containsKey(cls)) {
            try {
                innerEnumMap.put(cls, cls.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return innerEnumMap.get(cls);
    }

    public static Map<String, String> getEnumMap(Class<? extends BaseInnerEnum> cls) {
        return EnumFactory.getEnum(cls).getEnumMap();
    }

    public static String getEnumName(Class<? extends BaseInnerEnum> cls, int id) {
        return EnumFactory.getEnum(cls).getName(id);
    }

    public static int getEnumId(Class<? extends BaseInnerEnum> cls, String name) {
        return EnumFactory.getEnum(cls).getId(name);
    }

    public static int putEnum(Class<? extends BaseInnerEnum> cls, int id, String name) {
        EnumFactory.getEnum(cls).ENUM(id, name);
        return id;
    }
}

