/*
 * Decompiled with CFR 0.152.
 */
package com.mg.framework.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import com.mg.framework.log.FastjsonFilter;
import com.mg.framework.log.FastjsonSimpleFilter;
import com.mg.framework.log.ResponseBody;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResponse {
    private static Logger logger = LoggerFactory.getLogger(JsonResponse.class);

    public static synchronized String entityToJson(Object obj) {
        FastjsonFilter filter = new FastjsonFilter();
        return JSON.toJSONString((Object)obj, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteSlashAsSpecial});
    }

    public static synchronized String entityToJsonFull(Object obj, String filterPropertyNames) {
        FastjsonFilter filter = new FastjsonFilter(filterPropertyNames);
        return JSON.toJSONString((Object)obj, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteSlashAsSpecial});
    }

    public static synchronized String entityToJsonSimple(Object obj) {
        FastjsonSimpleFilter filter = new FastjsonSimpleFilter();
        return JSON.toJSONString((Object)obj, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteSlashAsSpecial});
    }

    public static synchronized String entityToJsonFullSimple(Object obj, String filterPropertyNames) {
        FastjsonSimpleFilter filter = new FastjsonSimpleFilter(filterPropertyNames);
        return JSON.toJSONString((Object)obj, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteSlashAsSpecial});
    }

    public static synchronized String error(int code, String message) {
        return JsonResponse.error(code, message, null);
    }

    public static synchronized String error(int code, String message, Object obj) {
        ResponseBody<Object> body = new ResponseBody<Object>(code, message, obj);
        return JsonResponse.entityToJsonSimple(body);
    }

    public static synchronized String success(Object obj, boolean isRefDetect, String[] filterPropNames, boolean isCamelToUnderline) {
        ResponseBody<Object> body = new ResponseBody<Object>(0, "", obj);
        FastjsonSimpleFilter filter = isCamelToUnderline ? new FastjsonFilter(filterPropNames) : new FastjsonSimpleFilter(filterPropNames);
        if (isRefDetect) {
            return JSON.toJSONString(body, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteSlashAsSpecial});
        }
        return JSON.toJSONString(body, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.QuoteFieldNames, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteSlashAsSpecial});
    }

    public static synchronized String successWithDate(Object obj, String dateFormat) {
        ResponseBody<Object> body = new ResponseBody<Object>(0, "", obj);
        SerializeConfig mapping = new SerializeConfig();
        mapping.put(Date.class, (Object)new SimpleDateFormatSerializer(dateFormat));
        mapping.put(java.sql.Date.class, (Object)new SimpleDateFormatSerializer(dateFormat));
        return JSON.toJSONString(body, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.QuoteFieldNames, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteSlashAsSpecial});
    }

    public static synchronized String success() {
        return JsonResponse.success(null, null);
    }

    public static synchronized String success(Object obj) {
        return JsonResponse.success(obj, false, null, false);
    }

    public static synchronized String success(Object obj, String[] filterPropNames) {
        return JsonResponse.success(obj, false, filterPropNames, false);
    }

    public static String toJson(Object obj, String[] filterPropNames) {
        return JsonResponse.toJson(obj, false, filterPropNames, false);
    }

    public static String toJson(Object obj, boolean isRefDetect, String[] filterPropNames, boolean isCamelToUnderline) {
        FastjsonSimpleFilter filter = isCamelToUnderline ? new FastjsonFilter(filterPropNames) : new FastjsonSimpleFilter(filterPropNames);
        if (isRefDetect) {
            return JSON.toJSONString((Object)obj, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteSlashAsSpecial});
        }
        return JSON.toJSONString((Object)obj, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.QuoteFieldNames, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteSlashAsSpecial});
    }

    public static synchronized String successMessage(String message) {
        return JsonResponse.successMessage(message, null, null);
    }

    public static synchronized String successMessage(String message, Object data) {
        return JsonResponse.successMessage(message, data, null);
    }

    public static synchronized String successMessage(String message, Object data, String[] filterPropNames) {
        ResponseBody<Object> body = new ResponseBody<Object>(ResponseBody.SUCCESS, null, data);
        body.setSuccessText(message);
        return JsonResponse.toJson(body, filterPropNames);
    }
}

