/*
 * Decompiled with CFR 0.152.
 */
package com.mg.framework.utils;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtil {
    private static Logger logger = LoggerFactory.getLogger(WebUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJsonBody(HttpServletRequest request) {
        Object body = null;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "utf-8"));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException ex) {
            logger.warn("\u4ecerequest\u91cc\u8bfb\u53d6\u6570\u636e\u6d41\u9519\u8bef", (Object)ex.toString());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    logger.warn("\u5173\u95edrequest\u8bfb\u53d6\u6570\u636e\u6d41\u9519\u8bef", (Object)ex.toString());
                }
            }
        }
        return stringBuilder.toString();
    }

    public static <T> T getJsonBody(HttpServletRequest request, Class<T> clazz) {
        String jsonString = WebUtil.getJsonBody(request);
        if (StringUtils.isNotBlank((String)jsonString)) {
            return (T)JSON.parseObject((String)jsonString, clazz);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getRequstBody(HttpServletRequest request, Class<T> clazz) {
        T bean;
        try {
            bean = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class arg0, Object arg1) {
                if (arg1 == null) {
                    return null;
                }
                if (!(arg1 instanceof String)) {
                    throw new ConversionException("\u53ea\u652f\u6301\u5b57\u7b26\u4e32\u8f6c\u6362 !");
                }
                String str = (String)arg1;
                if (StringUtils.isBlank((String)str)) {
                    return null;
                }
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    return sd.parse(str);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        }, Date.class);
        try {
            BeanUtils.populate(bean, (Map)request.getParameterMap());
            return bean;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

