/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.internal;

public class WsqHelper {
    static int[] BITMASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    static final int MAX_DHT_TABLES = 8;
    static final int MAX_HUFFBITS = 16;
    static final int MAX_HUFFCOUNTS_WSQ = 256;
    static final int W_TREELEN = 20;
    static final int Q_TREELEN = 64;
    static final int SOI_WSQ = 65440;
    static final int EOI_WSQ = 65441;
    static final int SOF_WSQ = 65442;
    static final int SOB_WSQ = 65443;
    static final int DTT_WSQ = 65444;
    static final int DQT_WSQ = 65445;
    static final int DHT_WSQ = 65446;
    static final int DRT_WSQ = 65447;
    static final int COM_WSQ = 65448;
    static final int STRT_SUBBAND_2 = 19;
    static final int STRT_SUBBAND_3 = 52;
    static final int MAX_SUBBANDS = 64;
    static final int NUM_SUBBANDS = 60;
    static final int STRT_SUBBAND_DEL = 60;
    static final int STRT_SIZE_REGION_2 = 4;
    static final int STRT_SIZE_REGION_3 = 51;
    static final int ANY_WSQ = 65535;
    static final int TBLS_N_SOF = 2;
    static final int TBLS_N_SOB = 4;

    static boolean isWsqFormat(byte[] bytes) {
        return bytes[0] == -1 && bytes[1] == -96 && bytes[bytes.length - 2] == -1 && bytes[bytes.length - 1] == -95;
    }

    static class Token {
        TableDHT[] tableDHT;
        TableDTT tableDTT;
        Table_DQT tableDQT;
        WavletTree[] wtree;
        QuantTree[] qtree;
        byte[] buffer;
        int pointer;

        Token(byte[] buffer) {
            this.buffer = buffer;
            this.pointer = 0;
        }

        void initialize() {
            this.tableDTT = new TableDTT();
            this.tableDQT = new Table_DQT();
            this.tableDHT = new TableDHT[8];
            for (int i = 0; i < 8; ++i) {
                this.tableDHT[i] = new TableDHT();
                this.tableDHT[i].tabdef = 0;
            }
        }

        long readInt() {
            byte byte1 = this.buffer[this.pointer++];
            byte byte2 = this.buffer[this.pointer++];
            byte byte3 = this.buffer[this.pointer++];
            byte byte4 = this.buffer[this.pointer++];
            return (0xFFL & (long)byte1) << 24 | (0xFFL & (long)byte2) << 16 | (0xFFL & (long)byte3) << 8 | 0xFFL & (long)byte4;
        }

        int readShort() {
            byte byte1 = this.buffer[this.pointer++];
            byte byte2 = this.buffer[this.pointer++];
            return (0xFF & byte1) << 8 | 0xFF & byte2;
        }

        int readByte() {
            byte byte1 = this.buffer[this.pointer++];
            return 0xFF & byte1;
        }

        byte[] readBytes(int size) {
            byte[] bytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                bytes[i] = this.buffer[this.pointer++];
            }
            return bytes;
        }
    }

    static class IntRef {
        int value;

        public IntRef(int value) {
            this.value = value;
        }
    }

    static class QuantTree {
        int x;
        int y;
        int lenx;
        int leny;

        QuantTree() {
        }
    }

    static class Table_DQT {
        public static final int MAX_SUBBANDS = 64;
        float binCenter;
        float[] qBin = new float[64];
        float[] zBin = new float[64];
        char dqtDef;

        Table_DQT() {
        }
    }

    static class TableDHT {
        private static final int MAX_HUFFBITS = 16;
        private static final int MAX_HUFFCOUNTS_WSQ = 256;
        byte tabdef;
        int[] huffbits = new int[16];
        int[] huffvalues = new int[257];

        TableDHT() {
        }
    }

    static class HuffmanTable {
        int tableLen;
        int bytesLeft;
        int tableId;
        int[] huffbits;
        int[] huffvalues;

        HuffmanTable() {
        }
    }

    static class HeaderFrm {
        int black;
        int white;
        int width;
        int height;
        float mShift;
        float rScale;
        int wsqEncoder;
        int software;

        HeaderFrm() {
        }
    }

    static class HuffCode {
        int size;
        int code;

        HuffCode() {
        }
    }

    static class TableDTT {
        float[] lofilt;
        float[] hifilt;
        int losz;
        int hisz;
        int lodef;
        int hidef;

        TableDTT() {
        }
    }

    static class WavletTree {
        int x;
        int y;
        int lenx;
        int leny;
        int invrw;
        int invcl;

        WavletTree() {
        }
    }
}

