/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.api.handler;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jnbis.api.handler.FileHandler;
import org.jnbis.api.model.Bitmap;

public final class BitmapHandler {
    private static final int[] MASKS = new int[]{255, 255, 255};
    private final Bitmap bitmap;

    public BitmapHandler(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public FileHandler toPng() {
        return new FileHandler(this.convert(this.bitmap, "png"));
    }

    public FileHandler toGif() {
        return new FileHandler(this.convert(this.bitmap, "gif"));
    }

    public FileHandler toJpg() {
        return new FileHandler(this.convert(this.bitmap, "jpeg"));
    }

    public Bitmap asBitmap() {
        return this.bitmap;
    }

    private byte[] convert(Bitmap bitmap, String format) {
        byte[] byArray;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        DataBufferByte buffer = new DataBufferByte(bitmap.getPixels(), bitmap.getLength());
        WritableRaster writableRaster = Raster.createPackedRaster(buffer, width, height, width, MASKS, null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        bufferedImage.setData(writableRaster);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, format, outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        outputStream.close();
        return byArray;
    }
}

