/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.api.handler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jnbis.api.handler.BitmapHandler;
import org.jnbis.internal.WsqDecoder;

public final class WsqHandler {
    private static final WsqDecoder DECODER = new WsqDecoder();

    public BitmapHandler decode(String fileName) {
        return this.decode(new File(fileName));
    }

    public BitmapHandler decode(File file) {
        try {
            return this.decode(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("unexpected error.", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BitmapHandler decode(InputStream inputStream) {
        try (BufferedInputStream input = new BufferedInputStream(inputStream);){
            BitmapHandler bitmapHandler;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[16384];
                while ((nRead = input.read(data, 0, data.length)) != -1) {
                    output.write(data, 0, nRead);
                }
                output.flush();
                bitmapHandler = this.decode(output.toByteArray());
            }
            return bitmapHandler;
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected error.", e);
        }
    }

    public BitmapHandler decode(byte[] data) {
        return new BitmapHandler(DECODER.decode(data));
    }
}

