/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.internal.record.reader;

import org.jnbis.api.model.record.MinutiaeData;
import org.jnbis.internal.NistHelper;
import org.jnbis.internal.record.reader.RecordReader;

public class MinutiaeDataReader
extends RecordReader {
    @Override
    public MinutiaeData read(NistHelper.Token token) {
        if (token.pos >= token.buffer.length) {
            throw new RuntimeException("T9::NULL pointer to T9 record");
        }
        MinutiaeData minutiaeData = new MinutiaeData();
        int start = token.pos++;
        NistHelper.Tag tag = this.getTagInfo(token);
        if (tag.field != 1) {
            throw new RuntimeException("T9::Invalid Record type = " + tag.type);
        }
        int length = Integer.parseInt(this.nextWord(token, NistHelper.TAG_SEP_GSFS, 1023, false));
        tag = this.getTagInfo(token);
        byte[] data = new byte[length - (token.pos - start)];
        System.arraycopy(token.buffer, token.pos, data, 0, data.length);
        token.pos += data.length;
        return minutiaeData;
    }

    @Override
    protected NistHelper.Tag getTagInfo(NistHelper.Token token) {
        String type = this.nextWord(token, NistHelper.TAG_SEP_DOT, 2, false);
        ++token.pos;
        String field = this.nextWord(token, NistHelper.TAG_SEP_COLN, 10, false);
        ++token.pos;
        return new NistHelper.Tag(Integer.parseInt(type), Integer.parseInt(field));
    }
}

