/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.api.handler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jnbis.api.model.Nist;
import org.jnbis.internal.NistDecoder;

public final class NistHandler {
    private static final NistDecoder DECODER = new NistDecoder();

    public Nist decode(String fileName) {
        return this.decode(new File(fileName));
    }

    public Nist decode(File file) {
        try {
            return this.decode(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("unexpected error.", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Nist decode(InputStream inputStream) {
        try (BufferedInputStream input = new BufferedInputStream(inputStream);){
            Nist nist;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[16384];
                while ((nRead = input.read(data, 0, data.length)) != -1) {
                    output.write(data, 0, nRead);
                }
                output.flush();
                nist = this.decode(output.toByteArray());
            }
            return nist;
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected error.", e);
        }
    }

    public Nist decode(byte[] data) {
        return DECODER.decode(data);
    }
}

