/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.internal.record.reader;

import org.jnbis.api.model.record.HighResolutionGrayscaleFingerprint;
import org.jnbis.internal.NistHelper;
import org.jnbis.internal.record.reader.RecordReader;

public class HighResolutionGrayscaleFingerprintReader
extends RecordReader {
    @Override
    public HighResolutionGrayscaleFingerprint read(NistHelper.Token token) {
        if (token.pos >= token.buffer.length) {
            throw new RuntimeException("T4::NULL pointer to T4 record");
        }
        HighResolutionGrayscaleFingerprint fingerprint = new HighResolutionGrayscaleFingerprint();
        int length = (int)this.read4BytesAsInt(token);
        byte idc = token.buffer[token.pos + 4];
        fingerprint.setImageDesignationCharacter(String.valueOf(idc));
        byte imp = token.buffer[token.pos + 5];
        fingerprint.setImpressionType(String.valueOf(imp));
        byte fingerPrintNo = token.buffer[token.pos + 6];
        fingerprint.setFingerPosition(String.valueOf(fingerPrintNo));
        byte isr = token.buffer[token.pos + 12];
        fingerprint.setImageScanningResolution(String.valueOf(isr));
        long hll = this.read2BytesAsInt(token, 13);
        fingerprint.setHorizontalLineLength(String.valueOf(hll));
        long vll = this.read2BytesAsInt(token, 15);
        fingerprint.setVerticalLineLength(String.valueOf(vll));
        byte gca = token.buffer[token.pos + 17];
        fingerprint.setCompressionAlgorithm(String.valueOf(gca));
        int dataSize = length - 18;
        if (token.pos + dataSize + 17 > token.buffer.length) {
            dataSize += token.buffer.length - token.pos - 18;
        }
        byte[] data = new byte[dataSize];
        System.arraycopy(token.buffer, token.pos + 18, data, 0, data.length + 18 - 18);
        token.pos += length;
        fingerprint.setImageDesignationCharacter(String.valueOf(fingerPrintNo));
        fingerprint.setImageData(data);
        fingerprint.setLogicalRecordLength(String.valueOf(length));
        return fingerprint;
    }
}

