/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.internal.record.reader;

import org.jnbis.internal.NistHelper;
import org.jnbis.internal.record.BaseRecord;
import org.jnbis.internal.record.reader.FacialAndSmtImageReader;
import org.jnbis.internal.record.reader.HighResolutionBinaryFingerprintReader;
import org.jnbis.internal.record.reader.HighResolutionGrayscaleFingerprintReader;
import org.jnbis.internal.record.reader.IrisImageReader;
import org.jnbis.internal.record.reader.LowResolutionBinaryFingerprintReader;
import org.jnbis.internal.record.reader.LowResolutionGrayscaleFingerprintReader;
import org.jnbis.internal.record.reader.MinutiaeDataReader;
import org.jnbis.internal.record.reader.RecordReader;
import org.jnbis.internal.record.reader.SignatureImageReader;
import org.jnbis.internal.record.reader.TransactionInfoReader;
import org.jnbis.internal.record.reader.UserDefinedImageReader;
import org.jnbis.internal.record.reader.UserDefinedTestingImageReader;
import org.jnbis.internal.record.reader.UserDefinedTextReader;
import org.jnbis.internal.record.reader.VariableResolutionFingerprintReader;
import org.jnbis.internal.record.reader.VariableResolutionLatentImageReader;
import org.jnbis.internal.record.reader.VariableResolutionPalmprintReader;

public class RecordReaderFactory {
    private static final RecordReader NOT_SUPPORTED = new RecordReader(){

        @Override
        public BaseRecord read(NistHelper.Token token) {
            throw new UnsupportedOperationException("record type: " + token.crt + " no supported!");
        }
    };
    private static final RecordReader[] READERS = new RecordReader[18];

    public RecordReader reader(NistHelper.Token token) {
        return READERS[token.crt];
    }

    public BaseRecord read(NistHelper.Token token) {
        return this.reader(token).read(token);
    }

    static {
        RecordReaderFactory.READERS[0] = new TransactionInfoReader();
        RecordReaderFactory.READERS[1] = new TransactionInfoReader();
        RecordReaderFactory.READERS[2] = new UserDefinedTextReader();
        RecordReaderFactory.READERS[3] = new LowResolutionGrayscaleFingerprintReader();
        RecordReaderFactory.READERS[4] = new HighResolutionGrayscaleFingerprintReader();
        RecordReaderFactory.READERS[5] = new LowResolutionBinaryFingerprintReader();
        RecordReaderFactory.READERS[6] = new HighResolutionBinaryFingerprintReader();
        RecordReaderFactory.READERS[7] = new UserDefinedImageReader();
        RecordReaderFactory.READERS[8] = new SignatureImageReader();
        RecordReaderFactory.READERS[9] = new MinutiaeDataReader();
        RecordReaderFactory.READERS[10] = new FacialAndSmtImageReader();
        RecordReaderFactory.READERS[11] = NOT_SUPPORTED;
        RecordReaderFactory.READERS[12] = NOT_SUPPORTED;
        RecordReaderFactory.READERS[13] = new VariableResolutionLatentImageReader();
        RecordReaderFactory.READERS[14] = new VariableResolutionFingerprintReader();
        RecordReaderFactory.READERS[15] = new VariableResolutionPalmprintReader();
        RecordReaderFactory.READERS[16] = new UserDefinedTestingImageReader();
        RecordReaderFactory.READERS[17] = new IrisImageReader();
    }
}

