/*
 * Decompiled with CFR 0.152.
 */
package org.jnbis.internal.record.reader;

import org.jnbis.api.model.record.UserDefinedTestingImage;
import org.jnbis.internal.NistHelper;
import org.jnbis.internal.record.reader.RecordReader;

public class UserDefinedTestingImageReader
extends RecordReader {
    @Override
    public UserDefinedTestingImage read(NistHelper.Token token) {
        byte[] data;
        if (token.pos >= token.buffer.length) {
            throw new RuntimeException("T16::NULL pointer to T16 record");
        }
        UserDefinedTestingImage userDefinedTestingImage = new UserDefinedTestingImage();
        int start = token.pos;
        NistHelper.Tag tag = this.getTagInfo(token);
        if (tag.field != 1) {
            throw new RuntimeException("T16::Invalid Record type = " + tag.type);
        }
        Integer length = Integer.parseInt(this.nextWord(token, NistHelper.TAG_SEP_GSFS, 1023, false));
        userDefinedTestingImage.setLogicalRecordLength(length.toString());
        block11: while (true) {
            ++token.pos;
            tag = this.getTagInfo(token);
            if (tag.field == 999) {
                data = new byte[length - (token.pos - start)];
                System.arraycopy(token.buffer, token.pos, data, 0, data.length);
                token.pos += data.length;
                break;
            }
            String word = this.nextWord(token, NistHelper.TAG_SEP_GSFS, 1023, false);
            switch (tag.field) {
                case 1: {
                    userDefinedTestingImage.setLogicalRecordLength(word);
                    continue block11;
                }
                case 2: {
                    userDefinedTestingImage.setImageDesignationCharacter(word);
                    continue block11;
                }
                case 6: {
                    userDefinedTestingImage.setHorizontalLineLength(word);
                    continue block11;
                }
                case 7: {
                    userDefinedTestingImage.setVerticalLineLength(word);
                    continue block11;
                }
                case 8: {
                    userDefinedTestingImage.setScaleUnits(word);
                    continue block11;
                }
                case 9: {
                    userDefinedTestingImage.setHorizontalPixelScale(word);
                    continue block11;
                }
                case 10: {
                    userDefinedTestingImage.setVerticalPixelScale(word);
                    continue block11;
                }
                case 11: {
                    userDefinedTestingImage.setCompressionAlgorithm(word);
                    continue block11;
                }
                case 12: {
                    userDefinedTestingImage.setBitsPerPixel(word);
                    continue block11;
                }
            }
            if ((2 >= tag.field || tag.field >= 6) && (12 >= tag.field || tag.field >= 999)) continue;
            userDefinedTestingImage.addUserDefinedField(tag.field, word);
        }
        userDefinedTestingImage.setImageData(data);
        return userDefinedTestingImage;
    }
}

