package com.mgnt.utils;

import java.util.Date;
import java.util.concurrent.TimeUnit;

import com.mgnt.utils.entities.TimeInterval;

/**
 * Created by michaelg on 19/01/2016.
 */
public class StamTest {
    public static void main(String[] args) {
//        testParsing();
//        testEncoderDecoder();
//        testSystemPropertyInitializer();
//        testParsingStringToTimeInterval();
        //testFormatStringToPreserveIndentaitonForHtml();
//        testGetStacktrace();
        testTimeInterval();
    }

    private static void testParsing() {
        StringBuilder num = new StringBuilder("-92");
        System.out.println(TextUtils.parseStringToInt(num, 10, null, null));
    }

    public static void testEncoderDecoder() {
        String helloEncoded = StringUnicodeEncoderDecoder.encodeStringToUnicodeSequence("\\u");
        System.out.println(helloEncoded);
        String result = StringUnicodeEncoderDecoder.decodeUnicodeSequenceToString("\\U0048\\U0065\\U006c\\U006c\\U006f");
        System.out.println(result);
        result = StringUnicodeEncoderDecoder.decodeUnicodeSequenceToString("  \\u0048\\u0065\\u006c\\u006c \\u006f   ");
        System.out.println(result);
        result = StringUnicodeEncoderDecoder.decodeUnicodeSequenceToString("  \\u0004\\u0065\\u006c\\u006c \\u006f   ");
        System.out.println(result);
        result = StringUnicodeEncoderDecoder.encodeStringToUnicodeSequence(result);
        System.out.println(result);
    }

    private static void testSystemPropertyInitializer() {
        System.out.println("RelevantPackage: " + TextUtils.getRelevantPackage());
        TextUtils.setRelevantPackage("com.utils.");
        System.out.println("RelevantPackage: " + TextUtils.getRelevantPackage());
    }

    private static void testParseStringToTimeInterval() {
        TimeInterval result = TextUtils.parseStringToTimeInterval("5s");
        System.out.println(new Date() + " Waiting for " + result.toMillis());
        TimeUtils.sleepFor(result);
        System.out.println(new Date() + " wait is over");
    }

    private static void testFormatStringToPreserveIndentaitonForHtml() {
        String rawText = "     *     This is non-indented line\n" +
                "     *       This is 2 spaces indented line\n" +
                "     *         This is 4 spaces indented line\n";
        String result = TextUtils.formatStringToPreserveIndentationForHtml(rawText);
        System.out.println(result + "\n" + StringUnicodeEncoderDecoder.encodeStringToUnicodeSequence(result));
    }
    
    private static void testGetStacktrace() {
    	String stacktrace = "java.lang.Exception: Dumb Stacktrace\n" + 
    			"at com.mot.nsa.errorhandling.TestController.handler(TestController.java:35)\n" + 
    			"at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\n" + 
    			"at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\n" + 
    			"at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\n" + 
    			"at java.lang.reflect.Method.invoke(Method.java:498)\n" + 
    			"at org.springframework.web.method.support.InvocableHandlerMethod.doInvoke(InvocableHandlerMethod.java:205)\n" + 
    			"at org.springframework.web.method.support.InvocableHandlerMethod.invokeForRequest(InvocableHandlerMethod.java:133)\n" + 
    			"at org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod.invokeAndHandle(ServletInvocableHandlerMethod.java:97)\n" + 
    			"at org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter.invokeHandlerMethod(RequestMappingHandlerAdapter.java:849)\n" + 
    			"at org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter.handleInternal(RequestMappingHandlerAdapter.java:760)\n" + 
    			"at org.springframework.web.servlet.mvc.method.AbstractHandlerMethodAdapter.handle(AbstractHandlerMethodAdapter.java:85)\n" + 
    			"at org.springframework.web.servlet.DispatcherServlet.doDispatch(DispatcherServlet.java:967)\n" + 
    			"at org.springframework.web.servlet.DispatcherServlet.doService(DispatcherServlet.java:901)\n" + 
    			"at org.springframework.web.servlet.FrameworkServlet.processRequest(FrameworkServlet.java:970)\n" + 
    			"at org.springframework.web.servlet.FrameworkServlet.doGet(FrameworkServlet.java:861)\n" + 
    			"at javax.servlet.http.HttpServlet.service(HttpServlet.java:635)\n" + 
    			"at org.springframework.web.servlet.FrameworkServlet.service(FrameworkServlet.java:846)\n" + 
    			"at javax.servlet.http.HttpServlet.service(HttpServlet.java:742)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:231)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)\n" + 
    			"at org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:52)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)\n" + 
    			"at org.springframework.boot.web.filter.ApplicationContextHeaderFilter.doFilterInternal(ApplicationContextHeaderFilter.java:55)\n" + 
    			"at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)\n" + 
    			"at org.springframework.boot.actuate.trace.WebRequestTraceFilter.doFilterInternal(WebRequestTraceFilter.java:111)\n" + 
    			"at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)\n" + 
    			"at org.springframework.web.filter.RequestContextFilter.doFilterInternal(RequestContextFilter.java:99)\n" + 
    			"at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)\n" + 
    			"at org.springframework.web.filter.HttpPutFormContentFilter.doFilterInternal(HttpPutFormContentFilter.java:109)\n" + 
    			"at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)\n" + 
    			"at org.springframework.web.filter.HiddenHttpMethodFilter.doFilterInternal(HiddenHttpMethodFilter.java:93)\n" + 
    			"at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)\n" + 
    			"at org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:197)\n" + 
    			"at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)\n" + 
    			"at org.springframework.boot.actuate.autoconfigure.MetricsFilter.doFilterInternal(MetricsFilter.java:103)\n" + 
    			"at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)\n" + 
    			"at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)\n" + 
    			"at org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:198)\n" + 
    			"at org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:96)\n" + 
    			"at org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:493)\n" + 
    			"at org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:140)\n" + 
    			"at org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:81)\n" + 
    			"at org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:87)\n" + 
    			"at org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:342)\n" + 
    			"at org.apache.coyote.http11.Http11Processor.service(Http11Processor.java:800)\n" + 
    			"at org.apache.coyote.AbstractProcessorLight.process(AbstractProcessorLight.java:66)\n" + 
    			"at org.apache.coyote.AbstractProtocol$ConnectionHandler.process(AbstractProtocol.java:806)\n" + 
    			"at org.apache.tomcat.util.net.NioEndpoint$SocketProcessor.doRun(NioEndpoint.java:1498)\n" + 
    			"at org.apache.tomcat.util.net.SocketProcessorBase.run(SocketProcessorBase.java:49)\n" + 
    			"at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)\n" + 
    			"at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)\n" + 
    			"at org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)\n" + 
    			"at java.lang.Thread.run(Thread.java:748)\n" + 
    			"Caused by: java.io.IOException: Test controller artificially generated exception\n" + 
    			"at com.mot.nsa.errorhandling.TestController.handler(TestController.java:31)\n" + 
    			"... 66 more";
    	
    	System.out.println(TextUtils.getStacktrace(stacktrace, "com.mot"));
    	TextUtils.setRelevantPackage("com.mot.");
    	System.out.println(TextUtils.getStacktrace(stacktrace));
    }
    
    private static void testTimeInterval() {
    	TimeInterval oneMilli = new TimeInterval(1L, TimeUnit.MILLISECONDS);
    	System.out.println("The number of nanoseconds in one millisecond is: " + oneMilli.toNanos());
    }
}
