/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.lifecycle.management;

import com.mgnt.lifecycle.management.BaseEntityFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEntity<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BaseEntity.class.getName());
    private static final Map<String, BaseEntityFactory> FACTORY_MAP = new HashMap<String, BaseEntityFactory>();

    protected static <I> void init(String type, BaseEntityFactory<I> factory) {
        FACTORY_MAP.put(type, factory);
    }

    public BaseEntity(String factoryKey) {
        this(factoryKey, null);
    }

    public BaseEntity(String factoryKey, String key) {
        BaseEntityFactory factory = FACTORY_MAP.get(factoryKey);
        if (factory != null) {
            if (StringUtils.isBlank((CharSequence)key)) {
                key = this.getClass().getSimpleName();
            }
            factory.putEntity(key, this);
        } else {
            LOGGER.error("Factory for type {} was not found", (Object)factoryKey);
        }
    }
}

