/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.lifecycle.management.backgroundrunner;

import com.mgnt.lifecycle.management.backgroundrunner.BackgroundRunnable;
import com.mgnt.lifecycle.management.backgroundrunner.BackgroundRunnableFactory;
import com.mgnt.utils.entities.TimeInterval;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundThreadsRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundThreadsRunner.class);
    private ScheduledExecutorService executorService;

    public BackgroundThreadsRunner() {
    }

    public BackgroundThreadsRunner(boolean isSelfInitializing) {
        if (isSelfInitializing) {
            this.init();
        }
    }

    @PostConstruct
    private void init() {
        Collection<BackgroundRunnable> taskCollection = BackgroundRunnableFactory.getAllInstances();
        this.executorService = Executors.newScheduledThreadPool(taskCollection.size());
        for (BackgroundRunnable task : taskCollection) {
            TimeInterval taskExecutionInterval = task.getTaskExecutionInterval();
            this.executorService.scheduleAtFixedRate(task, taskExecutionInterval.getValue(), taskExecutionInterval.getValue(), taskExecutionInterval.getTimeUnit());
        }
    }

    @PreDestroy
    private void cleanup() {
        LOGGER.info("Shutting down background tasks thread pool");
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }
}

