/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.lifecycle.management.backgroundrunner.example;

import com.mgnt.lifecycle.management.backgroundrunner.BaseBackgroundRunnable;
import com.mgnt.utils.TextUtils;
import com.mgnt.utils.entities.TimeInterval;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TypeOneTask
extends BaseBackgroundRunnable {
    private static final TimeInterval DEFAULT_VALUE = new TimeInterval(10L, TimeUnit.SECONDS);
    private String executionTimeIntervalStr;
    private TimeInterval executionTimeInterval;
    private String timeIntervalPropertyStr;
    private TimeInterval timeIntervalProperty;
    private String parsedIntegerPropertyStr;
    private Integer parsedIntegerProperty;

    public TypeOneTask() {
        this.init();
    }

    private void init() {
        this.setExecutionTimeIntervalStr("5s");
        this.setTimeIntervalPropertyStr("12h");
        this.setParsedIntegerPropertyStr("5 6 1");
        this.initParams();
    }

    @Override
    protected void initParamsForSpecificImplementation() {
        this.initTimeIntervalParam(this.getExecutionTimeIntervalStr(), DEFAULT_VALUE, PropertyName.EXECUTION_TIME_INTERVAL.name());
        this.initTimeIntervalParam(this.getTimeIntervalPropertyStr(), DEFAULT_VALUE, PropertyName.TIME_INTERVAL_PROPERTY.name());
        this.parseAndSetParsedIntegerProperty(this.getParsedIntegerPropertyStr());
    }

    @Override
    public TimeInterval getTaskExecutionInterval() {
        return this.getExecutionTimeInterval();
    }

    @Override
    public void setParamValue(TimeInterval value, String property) {
        PropertyName propertyName = null;
        try {
            propertyName = PropertyName.valueOf(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (propertyName != null) {
            switch (propertyName) {
                case EXECUTION_TIME_INTERVAL: {
                    this.setExecutionTimeInterval(value);
                    break;
                }
                case TIME_INTERVAL_PROPERTY: {
                    this.setTimeIntervalProperty(value);
                }
            }
        }
    }

    @Override
    public void run() {
        System.out.println(new Date() + " TypeOneTask is been executed. TimeInterval property is: " + this.getTimeIntervalProperty().getValue() + " " + (Object)((Object)this.getTimeIntervalProperty().getTimeUnit()) + " Parsed integer property: " + this.getParsedIntegerProperty());
    }

    public String getExecutionTimeIntervalStr() {
        return this.executionTimeIntervalStr;
    }

    public void setExecutionTimeIntervalStr(String executionTimeIntervalStr) {
        this.executionTimeIntervalStr = executionTimeIntervalStr;
    }

    public TimeInterval getExecutionTimeInterval() {
        return this.executionTimeInterval;
    }

    public void setExecutionTimeInterval(TimeInterval executionTimeInterval) {
        this.executionTimeInterval = executionTimeInterval;
    }

    public String getTimeIntervalPropertyStr() {
        return this.timeIntervalPropertyStr;
    }

    public void setTimeIntervalPropertyStr(String timeIntervalPropertyStr) {
        this.timeIntervalPropertyStr = timeIntervalPropertyStr;
    }

    public TimeInterval getTimeIntervalProperty() {
        return this.timeIntervalProperty;
    }

    public void setTimeIntervalProperty(TimeInterval timeIntervalProperty) {
        this.timeIntervalProperty = timeIntervalProperty;
    }

    public String getParsedIntegerPropertyStr() {
        return this.parsedIntegerPropertyStr;
    }

    public void setParsedIntegerPropertyStr(String parsedIntegerPropertyStr) {
        this.parsedIntegerPropertyStr = parsedIntegerPropertyStr;
    }

    public Integer getParsedIntegerProperty() {
        return this.parsedIntegerProperty;
    }

    public void setParsedIntegerProperty(Integer parsedIntegerProperty) {
        this.parsedIntegerProperty = parsedIntegerProperty;
    }

    private void parseAndSetParsedIntegerProperty(String parsedIntegerPropertyStr) {
        int value = TextUtils.parseStringToInt(parsedIntegerPropertyStr = parsedIntegerPropertyStr.replaceAll(" ", ""), 10, null, null);
        if (value < 1) {
            value = 10;
        }
        this.setParsedIntegerProperty(value);
    }

    private static enum PropertyName {
        EXECUTION_TIME_INTERVAL,
        TIME_INTERVAL_PROPERTY;

    }
}

