/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.lifecycle.management.httpclient;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HttpClient {
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private Map<String, String> requestPropertiesMap = new HashMap<String, String>();
    private String connectionUrl;

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String sendHttpRequest(HttpMethod callMethod) throws IOException {
        return this.sendHttpRequest(this.getConnectionUrl(), callMethod, null);
    }

    public String sendHttpRequest(String requestUrl, HttpMethod callMethod) throws IOException {
        return this.sendHttpRequest(requestUrl, callMethod, null);
    }

    public String sendHttpRequest(HttpMethod callMethod, String data) throws IOException {
        return this.sendHttpRequest(this.getConnectionUrl(), callMethod, data);
    }

    public String sendHttpRequest(String requestUrl, HttpMethod callMethod, String data) throws IOException {
        HttpURLConnection connection = this.sendRequest(requestUrl, callMethod, data);
        String response = this.readResponse(connection);
        connection.disconnect();
        return response;
    }

    public ByteBuffer sendHttpRequestForBinaryResponse(HttpMethod callMethod) throws IOException {
        return this.sendHttpRequestForBinaryResponse(this.getConnectionUrl(), callMethod, null);
    }

    public ByteBuffer sendHttpRequestForBinaryResponse(String requestUrl, HttpMethod callMethod) throws IOException {
        return this.sendHttpRequestForBinaryResponse(requestUrl, callMethod, null);
    }

    public ByteBuffer sendHttpRequestForBinaryResponse(HttpMethod callMethod, String data) throws IOException {
        return this.sendHttpRequestForBinaryResponse(this.getConnectionUrl(), callMethod, data);
    }

    public ByteBuffer sendHttpRequestForBinaryResponse(String requestUrl, HttpMethod callMethod, String data) throws IOException {
        HttpURLConnection connection = this.sendRequest(requestUrl, callMethod, data);
        ByteBuffer response = this.readBinaryResponse(connection);
        connection.disconnect();
        return response;
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        String response = "";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            response = sb.toString();
        }
        return response;
    }

    private ByteBuffer readBinaryResponse(HttpURLConnection connection) throws IOException {
        LinkedList<ByteBuffer> content = new LinkedList<ByteBuffer>();
        int totalLength = 0;
        InputStream is = connection.getInputStream();
        Object object = null;
        try {
            byte[] buff;
            int length;
            while ((length = is.read(buff = new byte[8192])) >= 0) {
                content.add(ByteBuffer.wrap(buff, 0, length));
                totalLength += length;
            }
        }
        catch (Throwable buff) {
            object = buff;
            throw buff;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable buff) {
                        ((Throwable)object).addSuppressed(buff);
                    }
                } else {
                    is.close();
                }
            }
        }
        ByteBuffer result = ByteBuffer.allocate(totalLength);
        for (ByteBuffer byteBuffer : content) {
            result.put(byteBuffer);
        }
        return result;
    }

    private HttpURLConnection sendRequest(String url, HttpMethod method, String data) throws IOException {
        boolean doOutput = StringUtils.isNotBlank((CharSequence)data);
        HttpURLConnection httpURLConnection = this.openHttpUrlConnection(url, method, doOutput);
        if (doOutput) {
            try (DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());){
                dataOutputStream.write(StandardCharsets.UTF_8.encode(data).array());
                dataOutputStream.flush();
            }
        }
        return httpURLConnection;
    }

    protected String getDefaultContentType() {
        return null;
    }

    public String getContentType() {
        String contentType = this.requestPropertiesMap.get(CONTENT_TYPE_HEADER_KEY);
        if (StringUtils.isBlank((CharSequence)contentType) && StringUtils.isNotBlank((CharSequence)(contentType = this.getDefaultContentType()))) {
            this.requestPropertiesMap.put(CONTENT_TYPE_HEADER_KEY, contentType);
        }
        return contentType;
    }

    public void setRequestProperty(String propertyName, String value) {
        if (StringUtils.isNotBlank((CharSequence)propertyName)) {
            this.requestPropertiesMap.put(propertyName, value);
        }
    }

    public String removeRequestProperty(String propertyName) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)propertyName)) {
            result = this.requestPropertiesMap.remove(propertyName);
        }
        return result;
    }

    public void clearAllRequestProperties() {
        this.requestPropertiesMap.clear();
    }

    public void setContentType(String contentType) {
        this.requestPropertiesMap.put(CONTENT_TYPE_HEADER_KEY, contentType);
    }

    protected HttpURLConnection openHttpUrlConnection(String url, HttpMethod method) throws IOException {
        return this.openHttpUrlConnection(url, method, false);
    }

    protected HttpURLConnection openHttpUrlConnection(String url, HttpMethod method, boolean doOutput) throws IOException {
        URL requestUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
        connection.setDoOutput(doOutput);
        connection.setRequestMethod(method.toString());
        for (String requestProperty : this.requestPropertiesMap.keySet()) {
            connection.setRequestProperty(requestProperty, this.requestPropertiesMap.get(requestProperty));
        }
        return connection;
    }

    public static enum HttpMethod {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE;

    }
}

