/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {
    private static final int MAX_READ_FAILURES = 10;

    public static String readFileAsString(String path, String charsetName) throws IOException {
        ByteBuffer content = FileUtils.internalReadFileAsByteArray(path);
        CharBuffer result = Charset.forName(charsetName).decode(content);
        char[] charContent = null;
        if (result.hasArray()) {
            charContent = result.array();
        } else {
            charContent = new char[result.limit()];
            result.get(charContent);
        }
        return new String(charContent);
    }

    public static String readFileAsString(String path) throws IOException {
        return FileUtils.readFileAsString(path, Charset.defaultCharset().name());
    }

    public static byte[] readFileAsByteArray(String path) throws IOException {
        return FileUtils.internalReadFileAsByteArray(path).array();
    }

    private static ByteBuffer internalReadFileAsByteArray(String path) throws IOException {
        ByteBuffer byteBuffer = null;
        Path filePath = FileSystems.getDefault().getPath(path, new String[0]);
        try (FileChannel fileChannel = FileChannel.open(filePath, StandardOpenOption.READ);){
            Long size = fileChannel.size();
            if (size > Integer.MAX_VALUE) {
                throw new IOException(MessageFormat.format("File {0} is too large. Its size is {1,number,integer} bytes which is larger then this method could handle ( {2,number,integer})", path, size, Integer.MAX_VALUE));
            }
            byteBuffer = ByteBuffer.allocate(size.intValue());
            int readBytes = 0;
            int totalReadBytes = 0;
            int failureCounter = 0;
            while ((readBytes = fileChannel.read(byteBuffer)) >= 0 && totalReadBytes < size.intValue()) {
                if (readBytes > 0) {
                    totalReadBytes += readBytes;
                    if (failureCounter <= 0) continue;
                    failureCounter = 0;
                    continue;
                }
                if (++failureCounter < 10) continue;
                throw new IOException(MessageFormat.format("File {0} could not be read for unknown reason", path));
            }
        }
        return (ByteBuffer)byteBuffer.flip();
    }

    public static String getFileName(String fullPath) {
        if (StringUtils.isNotEmpty((CharSequence)fullPath)) {
            int lastFileSeparator1 = fullPath.lastIndexOf("\\");
            int lastFileSeparator2 = fullPath.lastIndexOf("/");
            if (lastFileSeparator1 > 0 || lastFileSeparator2 > 0) {
                return fullPath.substring(Math.max(lastFileSeparator1, lastFileSeparator2) + 1);
            }
        }
        return fullPath;
    }
}

