/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.DefaultBaseTypeLimitingValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;

public class JsonUtils {
    private static final ObjectReader enabledDefaultTypingObjectReader;
    private static final ObjectWriter enabledDefaultTypingObjectWriter;
    private static final ObjectReader disabledDefaultTypingObjectReader;
    private static final ObjectWriter disabledDefaultTypingObjectWriter;

    public static String writeObjectToJsonString(Object object, boolean enableDefaultTyping) throws JsonProcessingException {
        String jsonData = null;
        if (object != null) {
            ObjectWriter objectWriter = enableDefaultTyping ? enabledDefaultTypingObjectWriter : disabledDefaultTypingObjectWriter;
            jsonData = objectWriter.writeValueAsString(object);
        }
        return jsonData;
    }

    public static String writeObjectToJsonString(Object object) throws JsonProcessingException {
        return JsonUtils.writeObjectToJsonString(object, false);
    }

    public static <T> T readObjectFromJsonString(String jsonString, Class<T> type, boolean enableDefaultTyping) throws IOException {
        ObjectReader objectReader = enableDefaultTyping ? enabledDefaultTypingObjectReader : disabledDefaultTypingObjectReader;
        Object data = objectReader.forType(type).readValue(jsonString);
        return (T)data;
    }

    public static <T> T readObjectFromJsonString(String jsonString, Class<T> type) throws IOException {
        return JsonUtils.readObjectFromJsonString(jsonString, type, false);
    }

    static {
        ObjectMapper objectMapper = JsonMapper.builder().build();
        objectMapper.registerModules(new Module[]{new JavaTimeModule()});
        disabledDefaultTypingObjectReader = objectMapper.reader();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        disabledDefaultTypingObjectWriter = objectMapper.writer();
        DefaultBaseTypeLimitingValidator ptv = new DefaultBaseTypeLimitingValidator();
        objectMapper = ((JsonMapper.Builder)JsonMapper.builder().activateDefaultTyping((PolymorphicTypeValidator)ptv)).build();
        objectMapper.registerModules(new Module[]{new JavaTimeModule()});
        enabledDefaultTypingObjectReader = objectMapper.reader();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        enabledDefaultTypingObjectWriter = objectMapper.writer();
    }
}

