/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.utils;

public class StringUnicodeEncoderDecoder {
    private static final String UNICODE_PREFIX = "\\u";
    private static final String UPPER_CASE_UNICODE_PREFIX = "\\U";
    private static final String UPPER_CASE_UNICODE_PREFIX_REGEX = "\\\\U";
    private static final String DELIMITER = "\\\\u";

    public static String encodeStringToUnicodeSequence(String txt) {
        StringBuilder result = new StringBuilder();
        if (txt != null && !txt.isEmpty()) {
            for (int i = 0; i < txt.length(); ++i) {
                result.append(StringUnicodeEncoderDecoder.convertCodePointToUnicodeString(Character.codePointAt(txt, i)));
                if (!Character.isHighSurrogate(txt.charAt(i))) continue;
                ++i;
            }
        }
        return result.toString();
    }

    public static String decodeUnicodeSequenceToString(String unicodeSequence) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder();
        try {
            unicodeSequence = StringUnicodeEncoderDecoder.replaceUpperCase_U_WithLoverCase(unicodeSequence);
            unicodeSequence = unicodeSequence.trim().substring(UNICODE_PREFIX.length());
            for (String codePointStr : unicodeSequence.split(DELIMITER)) {
                result.append(Character.toChars(Integer.parseInt(codePointStr.trim(), 16)));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error occurred while converting unicode sequence String to String", e);
        }
        return result.toString();
    }

    private static String replaceUpperCase_U_WithLoverCase(String unicodeSequence) {
        String result = unicodeSequence;
        if (unicodeSequence != null && unicodeSequence.contains(UPPER_CASE_UNICODE_PREFIX)) {
            result = unicodeSequence.replaceAll(UPPER_CASE_UNICODE_PREFIX_REGEX, DELIMITER);
        }
        return result;
    }

    private static String convertCodePointToUnicodeString(int codePoint) {
        StringBuilder result = new StringBuilder(UNICODE_PREFIX);
        String codePointHexStr = Integer.toHexString(codePoint);
        String string = codePointHexStr = codePointHexStr.startsWith("0") ? codePointHexStr.substring(1) : codePointHexStr;
        if (codePointHexStr.length() <= 4) {
            result.append(StringUnicodeEncoderDecoder.getPrecedingZerosStr(codePointHexStr.length()));
        }
        result.append(codePointHexStr);
        return result.toString();
    }

    private static String getPrecedingZerosStr(int codePointStrLength) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 4 - codePointStrLength; ++i) {
            result.append("0");
        }
        return result.toString();
    }
}

