/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.duration.logger;

import java.time.Instant;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import uk.co.mruoc.duration.calculator.DurationCalculator;
import uk.co.mruoc.duration.logger.DurationLogger;

public class MdcDurationLogger
implements DurationLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MdcDurationLogger.class);
    private final DurationCalculator durationCalculator;
    private final String operationName;
    private final String durationName;

    @Override
    public void log(String operation, Instant start) {
        long duration = this.durationCalculator.millisBetweenNowAnd(start);
        MDC.put((String)this.operationName, (String)operation);
        MDC.put((String)this.durationName, (String)Long.toString(duration));
        log.info("{} took {}ms", (Object)operation, (Object)duration);
        MDC.remove((String)this.operationName);
        MDC.remove((String)this.durationName);
    }

    @Generated
    MdcDurationLogger(DurationCalculator durationCalculator, String operationName, String durationName) {
        this.durationCalculator = durationCalculator;
        this.operationName = operationName;
        this.durationName = durationName;
    }

    @Generated
    public static MdcDurationLoggerBuilder builder() {
        return new MdcDurationLoggerBuilder();
    }

    @Generated
    public static class MdcDurationLoggerBuilder {
        @Generated
        private DurationCalculator durationCalculator;
        @Generated
        private String operationName;
        @Generated
        private String durationName;

        @Generated
        MdcDurationLoggerBuilder() {
        }

        @Generated
        public MdcDurationLoggerBuilder durationCalculator(DurationCalculator durationCalculator) {
            this.durationCalculator = durationCalculator;
            return this;
        }

        @Generated
        public MdcDurationLoggerBuilder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        @Generated
        public MdcDurationLoggerBuilder durationName(String durationName) {
            this.durationName = durationName;
            return this;
        }

        @Generated
        public MdcDurationLogger build() {
            return new MdcDurationLogger(this.durationCalculator, this.operationName, this.durationName);
        }

        @Generated
        public String toString() {
            return "MdcDurationLogger.MdcDurationLoggerBuilder(durationCalculator=" + this.durationCalculator + ", operationName=" + this.operationName + ", durationName=" + this.durationName + ")";
        }
    }
}

