/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.log;

import com.google.gson.Gson;
import com.savoirtech.logging.slf4j.json.logger.DebugLogger;
import com.savoirtech.logging.slf4j.json.logger.ErrorLogger;
import com.savoirtech.logging.slf4j.json.logger.InfoLogger;
import com.savoirtech.logging.slf4j.json.logger.JsonLogger;
import com.savoirtech.logging.slf4j.json.logger.NoopLogger;
import com.savoirtech.logging.slf4j.json.logger.TraceLogger;
import com.savoirtech.logging.slf4j.json.logger.WarnLogger;
import org.apache.commons.lang3.time.FastDateFormat;

public class Logger {
    private static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSSZ");
    private static final boolean INCLUDE_LOGGER_NAME = false;
    private final NoopLogger noopLogger = new NoopLogger();
    private final org.slf4j.Logger slf4jLogger;
    private final Gson gson;

    public Logger(org.slf4j.Logger slf4jLogger, Gson gson) {
        this.slf4jLogger = slf4jLogger;
        this.gson = gson;
    }

    public JsonLogger trace() {
        if (this.slf4jLogger.isTraceEnabled()) {
            return new TraceLogger(this.slf4jLogger, DATE_FORMATTER, this.gson, false);
        }
        return this.noopLogger;
    }

    public JsonLogger debug() {
        if (this.slf4jLogger.isDebugEnabled()) {
            return new DebugLogger(this.slf4jLogger, DATE_FORMATTER, this.gson, false);
        }
        return this.noopLogger;
    }

    public JsonLogger info() {
        if (this.slf4jLogger.isInfoEnabled()) {
            return new InfoLogger(this.slf4jLogger, DATE_FORMATTER, this.gson, false);
        }
        return this.noopLogger;
    }

    public JsonLogger warn() {
        if (this.slf4jLogger.isWarnEnabled()) {
            return new WarnLogger(this.slf4jLogger, DATE_FORMATTER, this.gson, false);
        }
        return this.noopLogger;
    }

    public JsonLogger error() {
        if (this.slf4jLogger.isErrorEnabled()) {
            return new ErrorLogger(this.slf4jLogger, DATE_FORMATTER, this.gson, false);
        }
        return this.noopLogger;
    }
}

