/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.log;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import uk.co.mruoc.log.EnvironmentVariableLogger;
import uk.co.mruoc.log.Logger;
import uk.co.mruoc.log.NoopVariableAppender;
import uk.co.mruoc.log.VariableAppender;

public class LoggerFactory {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
    private static final VariableAppender VARIABLE_APPENDER = new NoopVariableAppender();

    public static Logger getLogger(String name) {
        return LoggerFactory.getLogger(name, GSON, VARIABLE_APPENDER);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz, GSON, VARIABLE_APPENDER);
    }

    public static Logger getLogger(String name, Gson gson) {
        return LoggerFactory.getLogger(name, gson, VARIABLE_APPENDER);
    }

    public static Logger getLogger(Class<?> clazz, Gson gson) {
        return LoggerFactory.getLogger(clazz, gson, VARIABLE_APPENDER);
    }

    public static Logger getLogger(String name, VariableAppender variableAppender) {
        return LoggerFactory.getLogger(name, GSON, variableAppender);
    }

    public static Logger getLogger(Class<?> clazz, VariableAppender variableAppender) {
        return LoggerFactory.getLogger(clazz, GSON, variableAppender);
    }

    public static Logger getLogger(String name, Gson gson, VariableAppender variableAppender) {
        org.slf4j.Logger slf4jLogger = org.slf4j.LoggerFactory.getLogger((String)name);
        return new EnvironmentVariableLogger(slf4jLogger, gson, variableAppender);
    }

    public static Logger getLogger(Class<?> clazz, Gson gson, VariableAppender variableAppender) {
        org.slf4j.Logger slf4jLogger = org.slf4j.LoggerFactory.getLogger(clazz);
        return new EnvironmentVariableLogger(slf4jLogger, gson, variableAppender);
    }
}

