/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.json.mask;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.MapFunction;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.mruoc.json.mask.JsonPathConfig;
import uk.co.mruoc.json.mask.MaskFunction;

public class JsonMasker
implements UnaryOperator<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonMasker.class);
    private final ObjectMapper mapper;
    private final Collection<JsonPath> paths;
    private final MapFunction maskFunction;
    private final Configuration jsonPathConfig;

    @Override
    public String apply(String json) {
        try {
            if (StringUtils.isEmpty((CharSequence)json)) {
                return "";
            }
            JsonNode input = this.mapper.readTree(json);
            JsonNode output = this.mask(input);
            return output.toString();
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private JsonNode mask(JsonNode target) {
        JsonNode result = target.deepCopy();
        this.paths.forEach(path -> path.map((Object)result, this.maskFunction, this.jsonPathConfig));
        return result;
    }

    @Generated
    private static MapFunction $default$maskFunction() {
        return new MaskFunction();
    }

    @Generated
    private static Configuration $default$jsonPathConfig() {
        return JsonPathConfig.build();
    }

    @Generated
    public static JsonMaskerBuilder builder() {
        return new JsonMaskerBuilder();
    }

    @Generated
    public JsonMasker(ObjectMapper mapper, Collection<JsonPath> paths, MapFunction maskFunction, Configuration jsonPathConfig) {
        this.mapper = mapper;
        this.paths = paths;
        this.maskFunction = maskFunction;
        this.jsonPathConfig = jsonPathConfig;
    }

    @Generated
    public static class JsonMaskerBuilder {
        @Generated
        private ObjectMapper mapper;
        @Generated
        private Collection<JsonPath> paths;
        @Generated
        private boolean maskFunction$set;
        @Generated
        private MapFunction maskFunction$value;
        @Generated
        private boolean jsonPathConfig$set;
        @Generated
        private Configuration jsonPathConfig$value;

        @Generated
        JsonMaskerBuilder() {
        }

        @Generated
        public JsonMaskerBuilder mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        @Generated
        public JsonMaskerBuilder paths(Collection<JsonPath> paths) {
            this.paths = paths;
            return this;
        }

        @Generated
        public JsonMaskerBuilder maskFunction(MapFunction maskFunction) {
            this.maskFunction$value = maskFunction;
            this.maskFunction$set = true;
            return this;
        }

        @Generated
        public JsonMaskerBuilder jsonPathConfig(Configuration jsonPathConfig) {
            this.jsonPathConfig$value = jsonPathConfig;
            this.jsonPathConfig$set = true;
            return this;
        }

        @Generated
        public JsonMasker build() {
            MapFunction maskFunction$value = this.maskFunction$value;
            if (!this.maskFunction$set) {
                maskFunction$value = JsonMasker.$default$maskFunction();
            }
            Configuration jsonPathConfig$value = this.jsonPathConfig$value;
            if (!this.jsonPathConfig$set) {
                jsonPathConfig$value = JsonMasker.$default$jsonPathConfig();
            }
            return new JsonMasker(this.mapper, this.paths, maskFunction$value, jsonPathConfig$value);
        }

        @Generated
        public String toString() {
            return "JsonMasker.JsonMaskerBuilder(mapper=" + this.mapper + ", paths=" + this.paths + ", maskFunction$value=" + this.maskFunction$value + ", jsonPathConfig$value=" + this.jsonPathConfig$value + ")";
        }
    }
}

