/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.json.mask;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.function.UnaryOperator;
import lombok.Generated;
import uk.co.mruoc.string.mask.StringMasker;

public class ObjectMasker {
    private final UnaryOperator<String> stringMasker;

    public ObjectMasker() {
        this((UnaryOperator<String>)new StringMasker());
    }

    public Object mask(Object object) {
        if (object == null) {
            return this.stringMasker.apply(null);
        }
        if (object instanceof JsonNode) {
            return this.maskNode((JsonNode)object);
        }
        return this.stringMasker.apply(object.toString());
    }

    private JsonNode maskNode(JsonNode node) {
        if (node instanceof ObjectNode) {
            return this.maskObjectNode((ObjectNode)node);
        }
        if (node instanceof ArrayNode) {
            return this.maskArrayNode((ArrayNode)node);
        }
        return new TextNode((String)this.stringMasker.apply(node.asText()));
    }

    private ObjectNode maskObjectNode(ObjectNode node) {
        ObjectNode copy = node.deepCopy();
        node.fields().forEachRemaining(entry -> copy.set((String)entry.getKey(), this.maskNode((JsonNode)entry.getValue())));
        return copy;
    }

    private ArrayNode maskArrayNode(ArrayNode node) {
        ArrayNode copy = node.deepCopy();
        for (int i = 0; i < copy.size(); ++i) {
            copy.set(i, this.maskNode(node.get(i)));
        }
        return copy;
    }

    @Generated
    public ObjectMasker(UnaryOperator<String> stringMasker) {
        this.stringMasker = stringMasker;
    }
}

