/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.localphone.regionconfig;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.neovisionaries.i18n.CountryCode;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.mruoc.localphone.DefaultLocalPhoneNumber;
import uk.co.mruoc.localphone.LocalPhoneNumber;
import uk.co.mruoc.localphone.regionconfig.PhoneNumberParseFailedException;
import uk.co.mruoc.localphone.regionconfig.RegionConfig;

public abstract class AbstractRegionConfig
implements RegionConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRegionConfig.class);
    private static final PhoneNumberUtil UTIL = PhoneNumberUtil.getInstance();

    @Override
    public LocalPhoneNumber toLocal(String rawNumber) {
        Phonenumber.PhoneNumber parsedNumber = this.tryParse(rawNumber);
        Optional<CountryCode> localRegion = this.toLocalRegion(parsedNumber);
        if (localRegion.isPresent()) {
            return this.toLocalNumber(parsedNumber, localRegion.get());
        }
        return this.toInternationalNumber(parsedNumber);
    }

    protected Collection<PhoneNumberUtil.PhoneNumberType> getMobileTypes() {
        return Collections.singleton(PhoneNumberUtil.PhoneNumberType.MOBILE);
    }

    protected PhoneNumberUtil.PhoneNumberFormat getFormat() {
        return PhoneNumberUtil.PhoneNumberFormat.E164;
    }

    private Phonenumber.PhoneNumber tryParse(String number) {
        String region = this.getParentRegionAlpha2();
        Phonenumber.PhoneNumber originalParsed = this.parse(number, region);
        if (AbstractRegionConfig.isValid(originalParsed)) {
            return originalParsed;
        }
        return this.prefixPlusAndParse(number, region).orElse(originalParsed);
    }

    private Phonenumber.PhoneNumber parse(String number, String region) {
        try {
            return UTIL.parseAndKeepRawInput((CharSequence)number, region);
        }
        catch (NumberParseException e) {
            throw new PhoneNumberParseFailedException(e);
        }
    }

    private Optional<Phonenumber.PhoneNumber> prefixPlusAndParse(String number, String region) {
        try {
            String prefixed = this.prefixPlus(number);
            Phonenumber.PhoneNumber phoneNumber = UTIL.parseAndKeepRawInput((CharSequence)prefixed, region);
            phoneNumber.setRawInput(number);
            return Optional.of(phoneNumber);
        }
        catch (NumberParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    private String getParentRegionAlpha2() {
        return this.getParent().getAlpha2();
    }

    private String prefixPlus(String number) {
        return String.format("+%s", number);
    }

    private Optional<CountryCode> toLocalRegion(Phonenumber.PhoneNumber number) {
        return this.getChildren().stream().map(region -> AbstractRegionConfig.toLocalRegion(region, number)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private LocalPhoneNumber toLocalNumber(Phonenumber.PhoneNumber parsedNumber, CountryCode localRegion) {
        return DefaultLocalPhoneNumber.builder().defaultRegion(this.getParent()).raw(parsedNumber.getRawInput()).formatted(this.format(parsedNumber)).mobile(this.isMobile(parsedNumber)).region(localRegion).local(true).build();
    }

    private LocalPhoneNumber toInternationalNumber(Phonenumber.PhoneNumber parsedNumber) {
        log.debug("using raw input {} as formatted number because we have an international number and cannot guess the country code", (Object)parsedNumber.getRawInput());
        return DefaultLocalPhoneNumber.builder().defaultRegion(this.getParent()).raw(parsedNumber.getRawInput()).formatted(this.format(parsedNumber)).mobile(this.isMobile(parsedNumber)).local(false).build();
    }

    private boolean isMobile(Phonenumber.PhoneNumber number) {
        PhoneNumberUtil.PhoneNumberType type = UTIL.getNumberType(number);
        boolean mobile = this.getMobileTypes().contains(type);
        log.debug("number {} has type {} is mobile: {}", new Object[]{number, type, mobile});
        return mobile;
    }

    private String format(Phonenumber.PhoneNumber number) {
        return UTIL.format(number, this.getFormat());
    }

    private static Optional<CountryCode> toLocalRegion(CountryCode country, Phonenumber.PhoneNumber number) {
        boolean valid = UTIL.isValidNumberForRegion(number, country.getAlpha2());
        log.debug("number {} valid for country {}: {}", new Object[]{number, country, valid});
        if (valid) {
            return Optional.of(country);
        }
        return Optional.empty();
    }

    private static boolean isValid(Phonenumber.PhoneNumber phoneNumber) {
        return AbstractRegionConfig.doesNotHaveDuplicatedGermanCountryCodePrefix(phoneNumber) && UTIL.isValidNumber(phoneNumber);
    }

    private static boolean doesNotHaveDuplicatedGermanCountryCodePrefix(Phonenumber.PhoneNumber phoneNumber) {
        int countryCode = phoneNumber.getCountryCode();
        if (!AbstractRegionConfig.isGermanNumber(countryCode)) {
            return true;
        }
        String nationalNumber = Long.toString(phoneNumber.getNationalNumber());
        log.debug("national number {} country code {}", (Object)nationalNumber, (Object)countryCode);
        return !nationalNumber.startsWith(Integer.toString(countryCode));
    }

    private static boolean isGermanNumber(int countryCode) {
        return countryCode == 49;
    }
}

