/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.localphone.regionconfig;

import com.neovisionaries.i18n.CountryCode;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.mruoc.localphone.regionconfig.DefaultRegionConfig;
import uk.co.mruoc.localphone.regionconfig.GbRegionConfig;
import uk.co.mruoc.localphone.regionconfig.RegionConfig;
import uk.co.mruoc.localphone.regionconfig.RegionConfigProvider;
import uk.co.mruoc.localphone.regionconfig.RuRegionConfig;
import uk.co.mruoc.localphone.regionconfig.UsRegionConfig;

public class DefaultRegionConfigProvider
implements RegionConfigProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRegionConfigProvider.class);
    private final Map<CountryCode, RegionConfig> mappings = new EnumMap<CountryCode, RegionConfig>(CountryCode.class);

    public DefaultRegionConfigProvider() {
        this(DefaultRegionConfigProvider.buildDefaultMappings());
    }

    public DefaultRegionConfigProvider(Collection<RegionConfig> inputMappings) {
        inputMappings.forEach(this::add);
    }

    @Override
    public RegionConfig provide(CountryCode country) {
        return Optional.ofNullable(this.mappings.get(country)).orElse(new DefaultRegionConfig(country));
    }

    private void add(RegionConfig mapping) {
        this.mappings.put(mapping.getParent(), mapping);
    }

    private static Collection<RegionConfig> buildDefaultMappings() {
        return Arrays.asList(new GbRegionConfig(), new UsRegionConfig(), new RuRegionConfig());
    }
}

