/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.randomvalue.uuid;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import uk.co.mruoc.randomvalue.uuid.UuidGenerator;

public class NonRandomUuidGenerator
implements UuidGenerator {
    private static final List<UUID> DEFAULT_IDS = NonRandomUuidGenerator.buildIds();
    private final AtomicInteger index = new AtomicInteger();
    private final List<UUID> ids;

    public NonRandomUuidGenerator() {
        this(DEFAULT_IDS);
    }

    @Override
    public UUID get() {
        UUID id = this.ids.get(this.index.get());
        this.incrementOrResetIndex();
        return id;
    }

    private void incrementOrResetIndex() {
        int value = this.index.incrementAndGet();
        if (value >= this.ids.size()) {
            this.index.set(0);
        }
    }

    private static List<UUID> buildIds() {
        return Arrays.asList(UUID.fromString("76c9ec3b-b7aa-41ae-8066-796856e71e65"), UUID.fromString("85bbb05a-3cf8-45e5-bae8-430503164c3b"), UUID.fromString("0ec36d6b-145b-4c1e-9201-1f47a8eec9a5"), UUID.fromString("446846e6-bf16-4da5-af5b-9ad4a240fe5d"), UUID.fromString("507cc493-6998-49a4-9614-38ba4296eab6"));
    }

    @Generated
    public NonRandomUuidGenerator(List<UUID> ids) {
        this.ids = ids;
    }
}

