/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.string.firstunique;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Stream;
import uk.co.mruoc.string.firstunique.NoUniqueCharactersException;

public class FirstUniqueCharacter {
    private FirstUniqueCharacter() {
    }

    public static char forceFind(String input) {
        return FirstUniqueCharacter.find(input).orElseThrow(() -> new NoUniqueCharactersException(input)).charValue();
    }

    public static Optional<Character> find(String input) {
        FirstUniqueCharacter.validate(input);
        return FirstUniqueCharacter.toUniqueChars(input).findFirst();
    }

    private static void validate(String input) {
        if (input == null) {
            throw new NoUniqueCharactersException("cannot pass null string");
        }
    }

    private static Stream<Character> toUniqueChars(String input) {
        LinkedHashSet<Character> uniqueChars = new LinkedHashSet<Character>();
        for (char c : input.toCharArray()) {
            if (uniqueChars.contains(Character.valueOf(c))) {
                uniqueChars.remove(Character.valueOf(c));
                continue;
            }
            uniqueChars.add(Character.valueOf(c));
        }
        return uniqueChars.stream();
    }
}

