/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.string.mask;

import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class IgnoreFirstNAndLastNCharsMasker
implements UnaryOperator<String> {
    private static final char DEFAULT_MASK_CHAR = '*';
    private final int firstN;
    private final int lastN;
    private final char maskChar;

    public IgnoreFirstNAndLastNCharsMasker(int firstN, int lastN) {
        this(firstN, lastN, '*');
    }

    @Override
    public String apply(String value) {
        if (value == null) {
            return this.mask("null");
        }
        return this.mask(value);
    }

    private String mask(String value) {
        int maskedLength = value.length() - this.firstN - this.lastN;
        if (maskedLength < 0) {
            return value;
        }
        String firstUnmasked = value.substring(0, this.firstN);
        String masked = StringUtils.repeat((char)this.maskChar, (int)maskedLength);
        String lastUnmasked = value.substring(this.firstN + maskedLength);
        return firstUnmasked + masked + lastUnmasked;
    }

    @Generated
    public IgnoreFirstNAndLastNCharsMasker(int firstN, int lastN, char maskChar) {
        this.firstN = firstN;
        this.lastN = lastN;
        this.maskChar = maskChar;
    }
}

