/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.string.mask;

import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class IgnoreLastNCharsMasker
implements UnaryOperator<String> {
    private static final char DEFAULT_MASK_CHAR = '*';
    private final int lastN;
    private final char maskChar;

    public IgnoreLastNCharsMasker(int lastN) {
        this(lastN, '*');
    }

    @Override
    public String apply(String value) {
        if (value == null) {
            return this.mask("null");
        }
        if (value.length() <= this.lastN) {
            return value;
        }
        return this.mask(value);
    }

    private String mask(String value) {
        int maskedLength = value.length() - this.lastN;
        String masked = StringUtils.repeat((char)this.maskChar, (int)maskedLength);
        String unmasked = value.substring(maskedLength);
        return masked + unmasked;
    }

    @Generated
    public IgnoreLastNCharsMasker(int lastN, char maskChar) {
        this.lastN = lastN;
        this.maskChar = maskChar;
    }
}

