/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.test.clock;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetClock
extends Clock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OffsetClock.class);
    private static final Clock DEFAULT_CLOCK = Clock.systemUTC();
    private static final Duration DEFAULT_OFFSET = Duration.ZERO;
    private final Clock clock;
    private Duration offset;

    public OffsetClock() {
        this(DEFAULT_CLOCK);
    }

    public OffsetClock(Clock clock) {
        this(clock, DEFAULT_OFFSET);
    }

    public OffsetClock(Duration offset) {
        this(DEFAULT_CLOCK, offset);
    }

    @Override
    public ZoneId getZone() {
        return this.clock.getZone();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new OffsetClock(this.clock.withZone(zone), this.offset);
    }

    @Override
    public Instant instant() {
        Instant instant = this.clock.instant().plus(this.offset);
        log.debug("returning instant {} using offset {}", (Object)instant, (Object)this.offset);
        return instant;
    }

    public Duration getOffset() {
        return this.offset;
    }

    public void setOffset(Duration offset) {
        this.offset = offset;
        log.debug("set offset {}", (Object)offset);
    }

    public void reset() {
        this.setOffset(DEFAULT_OFFSET);
    }

    @Generated
    public OffsetClock(Clock clock, Duration offset) {
        this.clock = clock;
        this.offset = offset;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OffsetClock)) {
            return false;
        }
        OffsetClock other = (OffsetClock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Clock this$clock = this.clock;
        Clock other$clock = other.clock;
        if (this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock)) {
            return false;
        }
        Duration this$offset = this.getOffset();
        Duration other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OffsetClock;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Clock $clock = this.clock;
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        Duration $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        return result;
    }
}

