/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.test.clock;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverridableClock
extends Clock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OverridableClock.class);
    private static final Clock DEFAULT_CLOCK = Clock.systemUTC();
    private static final Duration DEFAULT_OFFSET = Duration.ZERO;
    private final Clock clock;
    private Duration offset;
    private List<Instant> overrides;

    public OverridableClock() {
        this(Collections.emptyList());
    }

    public OverridableClock(Instant ... overrides) {
        this(OverridableClock.toList(overrides));
    }

    public OverridableClock(Collection<Instant> overrides) {
        this(DEFAULT_CLOCK, DEFAULT_OFFSET, overrides);
    }

    public OverridableClock(Clock clock, Duration offset, Collection<Instant> overrides) {
        this.clock = clock;
        this.offset = offset;
        this.overrides = OverridableClock.toList(overrides);
    }

    public void setOffset(Duration offset) {
        log.debug("set offset {}", (Object)offset);
        this.offset = offset;
    }

    public Duration getOffset() {
        return this.offset;
    }

    public void clearOffset() {
        this.setOffset(Duration.ZERO);
    }

    public void setOverrides(Instant ... overrides) {
        this.setOverrides(new ArrayList<Instant>(Arrays.asList(overrides)));
    }

    public void setOverrides(Collection<Instant> overrides) {
        log.debug("set overrides {}", overrides);
        this.overrides = OverridableClock.toList(overrides);
    }

    public Collection<Instant> getOverrides() {
        return this.overrides;
    }

    public void clearOverrides() {
        this.setOverrides(Collections.emptyList());
    }

    @Override
    public ZoneId getZone() {
        return this.clock.getZone();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new OverridableClock(this.clock.withZone(zone), this.offset, this.overrides);
    }

    @Override
    public Instant instant() {
        Instant instant = this.getOverride().orElseGet(this::getCurrentTime);
        return instant.plus(this.offset);
    }

    private Optional<Instant> getOverride() {
        if (CollectionUtils.isEmpty(this.overrides)) {
            return Optional.empty();
        }
        Instant override = this.overrides.remove(0);
        log.debug("returning override time {}", (Object)override);
        return Optional.ofNullable(override);
    }

    private Instant getCurrentTime() {
        Instant instant = this.clock.instant();
        log.debug("returning current time {}", (Object)instant);
        return instant;
    }

    private static List<Instant> toList(Instant ... values) {
        return OverridableClock.toList(Arrays.asList(values));
    }

    private static List<Instant> toList(Collection<Instant> values) {
        return new ArrayList<Instant>(values);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OverridableClock)) {
            return false;
        }
        OverridableClock other = (OverridableClock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Clock this$clock = this.clock;
        Clock other$clock = other.clock;
        if (this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock)) {
            return false;
        }
        Duration this$offset = this.getOffset();
        Duration other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Collection<Instant> this$overrides = this.getOverrides();
        Collection<Instant> other$overrides = other.getOverrides();
        return !(this$overrides == null ? other$overrides != null : !((Object)this$overrides).equals(other$overrides));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OverridableClock;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Clock $clock = this.clock;
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        Duration $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Collection<Instant> $overrides = this.getOverrides();
        result = result * 59 + ($overrides == null ? 43 : ((Object)$overrides).hashCode());
        return result;
    }
}

