/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.test.clock;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreConfiguredClock
extends Clock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreConfiguredClock.class);
    private static final Clock DEFAULT_CLOCK = Clock.systemUTC();
    private final Clock clock;
    private final List<Instant> values;
    private final IntUnaryOperator incrementOrReset;
    private final AtomicInteger index = new AtomicInteger();

    public PreConfiguredClock(Instant ... values) {
        this(Arrays.asList(values));
    }

    public PreConfiguredClock(Collection<Instant> values) {
        this(DEFAULT_CLOCK, new ArrayList<Instant>(values));
    }

    public PreConfiguredClock(Clock clock, List<Instant> values) {
        this.clock = clock;
        this.values = values;
        this.incrementOrReset = new IncrementOrReset(values.size());
        log.debug("configured with values {}", values);
    }

    @Override
    public ZoneId getZone() {
        return this.clock.getZone();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new PreConfiguredClock(this.clock.withZone(zone), this.values);
    }

    @Override
    public Instant instant() {
        Instant instant = this.calculateInstant();
        log.debug("returning instant {}", (Object)instant);
        return instant;
    }

    private Instant calculateInstant() {
        if (this.values.isEmpty()) {
            log.info("returning current time");
            return this.clock.instant();
        }
        return this.values.get(this.index.getAndUpdate(this.incrementOrReset));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreConfiguredClock)) {
            return false;
        }
        PreConfiguredClock other = (PreConfiguredClock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Clock this$clock = this.clock;
        Clock other$clock = other.clock;
        if (this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock)) {
            return false;
        }
        List<Instant> this$values = this.values;
        List<Instant> other$values = other.values;
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        IntUnaryOperator this$incrementOrReset = this.incrementOrReset;
        IntUnaryOperator other$incrementOrReset = other.incrementOrReset;
        if (this$incrementOrReset == null ? other$incrementOrReset != null : !this$incrementOrReset.equals(other$incrementOrReset)) {
            return false;
        }
        AtomicInteger this$index = this.index;
        AtomicInteger other$index = other.index;
        return !(this$index == null ? other$index != null : !this$index.equals(other$index));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PreConfiguredClock;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Clock $clock = this.clock;
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        List<Instant> $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        IntUnaryOperator $incrementOrReset = this.incrementOrReset;
        result = result * 59 + ($incrementOrReset == null ? 43 : $incrementOrReset.hashCode());
        AtomicInteger $index = this.index;
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        return result;
    }

    public static class IncrementOrReset
    implements IntUnaryOperator {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(IncrementOrReset.class);
        private final int size;

        @Override
        public int applyAsInt(int operand) {
            log.debug("using index for configured value {}", (Object)operand);
            int incremented = operand + 1;
            if (incremented >= this.size) {
                return 0;
            }
            return incremented;
        }

        @Generated
        public IncrementOrReset(int size) {
            this.size = size;
        }
    }
}

