/*
 * Decompiled with CFR 0.152.
 */
package com.github.mickleroy.aem.sass.impl;

import com.adobe.granite.ui.clientlibs.script.CompilerContext;
import com.adobe.granite.ui.clientlibs.script.ScriptResource;
import com.github.mickleroy.aem.sass.exceptions.ImportFileNotFoundException;
import com.github.mickleroy.aem.sass.util.ScriptResourceUtil;
import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.Importer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileImporter
implements Importer {
    private CompilerContext context;
    private String pathToPrimaryFile;
    private String pathToCurrentFile;
    private static final String[] PATH_MATCHERS = new String[]{"%s%s%s", "%s%s%s.scss", "%s%s_%s", "%s%s_%s.scss"};
    private static Logger log = LoggerFactory.getLogger(FileImporter.class);

    public FileImporter(CompilerContext context, String path) {
        this.context = context;
        this.pathToPrimaryFile = path;
        this.pathToCurrentFile = path;
    }

    @Override
    public Collection<Import> apply(String url, Import previous) {
        if (this.shouldSkipImporter(url)) {
            return null;
        }
        ScriptResource resource = null;
        String currentDir = this.getCurrentDirectory(previous);
        String pathToFile = this.getPathToFile(url);
        String getFileName = this.getFileName(url);
        if (url.startsWith("/")) {
            currentDir = "";
        }
        for (String matcher : PATH_MATCHERS) {
            String pathToImport = String.format(matcher, currentDir, pathToFile, getFileName);
            resource = this.getResource(pathToImport);
            if (resource != null) break;
        }
        if (resource == null) {
            throw new ImportFileNotFoundException(url);
        }
        try {
            return Collections.singletonList(new Import(new URI(resource.getName()), new URI(resource.getName()), ScriptResourceUtil.retrieveContents(resource)));
        }
        catch (IOException | URISyntaxException ex) {
            log.error("Could not process import", (Throwable)ex);
            return null;
        }
    }

    private String getFileName(String url) {
        return url.substring(url.lastIndexOf("/") + 1, url.length());
    }

    private String getPathToFile(String url) {
        return url.substring(0, url.lastIndexOf("/") + 1);
    }

    private boolean shouldSkipImporter(String url) {
        return url.startsWith("http") || url.startsWith("url(") || url.endsWith(".css");
    }

    private ScriptResource getResource(String path) {
        try {
            return this.context.getResourceProvider().getResource(path);
        }
        catch (IOException ioEx) {
            log.error("IO Error", (Throwable)ioEx);
            return null;
        }
    }

    private String getCurrentDirectory(Import previous) {
        this.pathToCurrentFile = "stdin".equals(previous.getAbsoluteUri().getPath()) ? this.pathToPrimaryFile : previous.getAbsoluteUri().getPath();
        return this.pathToCurrentFile.substring(0, this.pathToCurrentFile.lastIndexOf("/") + 1);
    }
}

