/*
 * Decompiled with CFR 0.152.
 */
package com.github.middleout;

import java.math.BigInteger;
import java.util.Date;
import org.joda.time.DateTime;

public class SnowflakeLUId {
    private static final long TWITTER_EPOCH = 1288834974657L;
    private static final int WORKER_BITS = 10;
    private static final int SEQUENCE_BITS = 12;
    private static final int TIMESTAMP_SHIFT_BITS = 22;
    private static final int MAX_WORKER_ID = new BigInteger("2").pow(10).intValue();
    private static final int MAX_SEQUENCE_NUMBER = new BigInteger("2").pow(12).intValue();
    private volatile long lastTimestamp = 0L;
    private volatile long sequence = 0L;
    private long workerId = 1L;

    public SnowflakeLUId(int workerId) {
        if (workerId < 0 || MAX_WORKER_ID < workerId) {
            throw new IllegalArgumentException(String.format("worker id [%d] is out of range", workerId));
        }
        this.workerId = workerId;
    }

    public long nextLUId() {
        long currentTimestamp = SnowflakeLUId.getCurrentTimestamp();
        return this.generateNextId(currentTimestamp);
    }

    private synchronized long generateNextId(long currentTimestamp) {
        if (currentTimestamp < this.lastTimestamp) {
            throw new IllegalStateException("current system clock is behind previous measurement");
        }
        if (this.lastTimestamp == currentTimestamp) {
            ++this.sequence;
            if (this.sequence >= (long)MAX_SEQUENCE_NUMBER) {
                while (this.lastTimestamp == currentTimestamp) {
                    currentTimestamp = SnowflakeLUId.getCurrentTimestamp();
                }
                this.sequence = 0L;
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp << 22 | this.workerId << 12 | this.sequence;
    }

    private static long getCurrentTimestamp() {
        return DateTime.now().getMillis() - 1288834974657L;
    }

    public static long getTimeFilter(Date dt) {
        return SnowflakeLUId.getTimeFilter(dt.getTime());
    }

    public static long getTimeFilter(long dt) {
        return dt - 1288834974657L << 22;
    }
}

