/*
 * Decompiled with CFR 0.152.
 */
package com.github.miemiedev.mybatis.paginator;

import com.github.miemiedev.mybatis.paginator.dialect.Dialect;
import com.github.miemiedev.mybatis.paginator.domain.PageBounds;
import com.github.miemiedev.mybatis.paginator.domain.PageList;
import com.github.miemiedev.mybatis.paginator.domain.Paginator;
import com.github.miemiedev.mybatis.paginator.support.PropertiesHelper;
import com.github.miemiedev.mybatis.paginator.support.SQLHelp;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class OffsetLimitInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(OffsetLimitInterceptor.class);
    static int MAPPED_STATEMENT_INDEX = 0;
    static int PARAMETER_INDEX = 1;
    static int ROWBOUNDS_INDEX = 2;
    static int RESULT_HANDLER_INDEX = 3;
    static ExecutorService Pool;
    Dialect dialect;
    boolean asyncTotalCount = false;

    public Object intercept(final Invocation invocation) throws Throwable {
        final Executor executor = (Executor)invocation.getTarget();
        Object[] queryArgs = invocation.getArgs();
        final MappedStatement ms = (MappedStatement)queryArgs[MAPPED_STATEMENT_INDEX];
        final Object parameter = queryArgs[PARAMETER_INDEX];
        RowBounds rowBounds = (RowBounds)queryArgs[ROWBOUNDS_INDEX];
        PageBounds pageBounds = new PageBounds(rowBounds);
        int offset = pageBounds.getOffset();
        final int limit = pageBounds.getLimit();
        final int page = pageBounds.getPage();
        final BoundSql boundSql = ms.getBoundSql(parameter);
        final StringBuffer bufferSql = new StringBuffer(boundSql.getSql().trim());
        if (bufferSql.lastIndexOf(";") == bufferSql.length() - 1) {
            bufferSql.deleteCharAt(bufferSql.length() - 1);
        }
        String sql = bufferSql.toString();
        if (pageBounds.getOrders() != null && !pageBounds.getOrders().isEmpty()) {
            sql = this.dialect.getSortString(sql, pageBounds.getOrders());
        }
        Callable countTask = null;
        if (this.dialect.supportsLimit() && (offset != 0 || limit != Integer.MAX_VALUE)) {
            if (pageBounds.isContainsTotalCount()) {
                countTask = new Callable(){

                    public Object call() throws Exception {
                        Integer count = null;
                        Cache cache = ms.getCache();
                        if (cache != null && ms.isUseCache()) {
                            CacheKey cacheKey = executor.createCacheKey(ms, parameter, (RowBounds)new PageBounds(), OffsetLimitInterceptor.this.copyFromBoundSql(ms, boundSql, bufferSql.toString()));
                            count = (Integer)cache.getObject((Object)cacheKey);
                            if (count == null) {
                                count = SQLHelp.getCount(bufferSql.toString(), ms, parameter, boundSql, OffsetLimitInterceptor.this.dialect);
                                cache.putObject((Object)cacheKey, (Object)count);
                            }
                        } else {
                            count = SQLHelp.getCount(bufferSql.toString(), ms, parameter, boundSql, OffsetLimitInterceptor.this.dialect);
                        }
                        return new Paginator(page, limit, count);
                    }
                };
            }
            sql = this.dialect.supportsLimitOffset() ? this.dialect.getLimitString(sql, offset, limit) : this.dialect.getLimitString(sql, 0, limit);
            queryArgs[OffsetLimitInterceptor.ROWBOUNDS_INDEX] = new RowBounds(0, Integer.MAX_VALUE);
        }
        queryArgs[OffsetLimitInterceptor.MAPPED_STATEMENT_INDEX] = this.copyFromNewSql(ms, boundSql, sql);
        Boolean async = pageBounds.getAsyncTotalCount() == null ? this.asyncTotalCount : pageBounds.getAsyncTotalCount();
        Future listFuture = this.call(new Callable<List>(){

            @Override
            public List call() throws Exception {
                return (List)invocation.proceed();
            }
        }, async);
        if (countTask != null) {
            Future countFutrue = this.call(countTask, async);
            return new PageList((Collection)listFuture.get(), (Paginator)countFutrue.get());
        }
        return listFuture.get();
    }

    private <T> Future<T> call(Callable callable, boolean async) {
        if (async) {
            return Pool.submit(callable);
        }
        FutureTask future = new FutureTask(callable);
        future.run();
        return future;
    }

    private MappedStatement copyFromNewSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = this.copyFromBoundSql(ms, boundSql, sql);
        return this.copyFromMappedStatement(ms, new BoundSqlSqlSource(newBoundSql));
    }

    private BoundSql copyFromBoundSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuffer keyProperties = new StringBuffer();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        PropertiesHelper propertiesHelper = new PropertiesHelper(properties);
        String dialectClass = propertiesHelper.getRequiredString("dialectClass");
        try {
            this.setDialect((Dialect)Class.forName(dialectClass).newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("cannot create dialect instance by dialectClass:" + dialectClass, e);
        }
        this.setAsyncTotalCount(propertiesHelper.getBoolean("asyncTotalCount", false));
        this.setPoolMaxSize(propertiesHelper.getInt("poolMaxSize", 0));
    }

    public void setDialect(Dialect dialect) {
        logger.debug("dialectClass: {} ", (Object)dialect.getClass().getName());
        this.dialect = dialect;
    }

    public void setAsyncTotalCount(boolean asyncTotalCount) {
        logger.debug("asyncTotalCount: {} ", (Object)asyncTotalCount);
        this.asyncTotalCount = asyncTotalCount;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        if (poolMaxSize > 0) {
            logger.debug("poolMaxSize: {} ", (Object)poolMaxSize);
            Pool = Executors.newFixedThreadPool(poolMaxSize);
        } else {
            Pool = Executors.newCachedThreadPool();
        }
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

